/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.transform;

import com.alibaba.graphscope.common.exception.OpArgIllegalException;
import com.alibaba.graphscope.common.intermediate.ArgAggFn;
import com.alibaba.graphscope.common.intermediate.ArgUtils;
import com.alibaba.graphscope.common.intermediate.InterOpCollection;
import com.alibaba.graphscope.common.intermediate.MatchSentence;
import com.alibaba.graphscope.common.intermediate.operator.AsNoneOp;
import com.alibaba.graphscope.common.intermediate.operator.ExpandOp;
import com.alibaba.graphscope.common.intermediate.operator.GetVOp;
import com.alibaba.graphscope.common.intermediate.operator.GroupOp;
import com.alibaba.graphscope.common.intermediate.operator.InterOpBase;
import com.alibaba.graphscope.common.intermediate.operator.LimitOp;
import com.alibaba.graphscope.common.intermediate.operator.MatchOp;
import com.alibaba.graphscope.common.intermediate.operator.OpArg;
import com.alibaba.graphscope.common.intermediate.operator.PathExpandOp;
import com.alibaba.graphscope.common.intermediate.operator.ProjectOp;
import com.alibaba.graphscope.common.intermediate.operator.QueryParams;
import com.alibaba.graphscope.common.intermediate.operator.SampleOp;
import com.alibaba.graphscope.common.intermediate.operator.ScanFusionOp;
import com.alibaba.graphscope.common.intermediate.operator.SelectOp;
import com.alibaba.graphscope.common.intermediate.operator.SubGraphAsUnionOp;
import com.alibaba.graphscope.common.intermediate.operator.UnfoldOp;
import com.alibaba.graphscope.common.intermediate.operator.UnionOp;
import com.alibaba.graphscope.common.jna.type.FfiAlias;
import com.alibaba.graphscope.common.jna.type.FfiConst;
import com.alibaba.graphscope.common.jna.type.FfiDirection;
import com.alibaba.graphscope.common.jna.type.FfiExpandOpt;
import com.alibaba.graphscope.common.jna.type.FfiJoinKind;
import com.alibaba.graphscope.common.jna.type.FfiNameIdOpt;
import com.alibaba.graphscope.common.jna.type.FfiNameOrId;
import com.alibaba.graphscope.common.jna.type.FfiScanOpt;
import com.alibaba.graphscope.common.jna.type.FfiVOpt;
import com.alibaba.graphscope.gremlin.InterOpCollectionBuilder;
import com.alibaba.graphscope.gremlin.Utils;
import com.alibaba.graphscope.gremlin.antlr4.GremlinAntlrToJava;
import com.alibaba.graphscope.gremlin.plugin.step.ExpandFusionStep;
import com.alibaba.graphscope.gremlin.plugin.step.ExprStep;
import com.alibaba.graphscope.gremlin.plugin.step.GroupCountStep;
import com.alibaba.graphscope.gremlin.plugin.step.GroupStep;
import com.alibaba.graphscope.gremlin.plugin.step.PathExpandStep;
import com.alibaba.graphscope.gremlin.plugin.step.ScanFusionStep;
import com.alibaba.graphscope.gremlin.transform.ExprArg;
import com.alibaba.graphscope.gremlin.transform.PredicateExprTransformFactory;
import com.alibaba.graphscope.gremlin.transform.TraversalParentTransformFactory;
import com.alibaba.graphscope.gremlin.transform.alias.AliasArg;
import com.alibaba.graphscope.gremlin.transform.alias.AliasManager;
import com.alibaba.graphscope.gremlin.transform.alias.AliasPrefixType;
import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ColumnTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.IdentityTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ValueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.UnionStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.CoinStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DedupGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.NotStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WhereTraversalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ConstantStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectOneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TraversalMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.UnfoldStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SubgraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.javatuples.Pair;

public enum StepTransformFactory implements Function<Step, InterOpBase>
{
    GRAPH_STEP{

        @Override
        public InterOpBase apply(Step step) {
            GraphStep graphStep = (GraphStep)step;
            ScanFusionOp op = new ScanFusionOp();
            op.setScanOpt(new OpArg(graphStep, this.SCAN_OPT));
            if (graphStep.getIds().length > 0) {
                op.setIds(new OpArg(graphStep, this.CONST_IDS_FROM_STEP));
            }
            return op;
        }
    }
    ,
    SCAN_FUSION_STEP{

        @Override
        public InterOpBase apply(Step step) {
            CoinStep coinStep;
            ScanFusionStep scanFusionStep = (ScanFusionStep)step;
            ScanFusionOp op = new ScanFusionOp();
            op.setScanOpt(new OpArg(scanFusionStep, this.SCAN_OPT));
            if (scanFusionStep.getIds() != null && scanFusionStep.getIds().length > 0) {
                op.setIds(new OpArg(scanFusionStep, this.CONST_IDS_FROM_STEP));
            }
            QueryParams params = new QueryParams();
            List<String> labels = scanFusionStep.getGraphLabels();
            for (String label : labels) {
                params.addTable(ArgUtils.asNameOrId(label));
            }
            List<HasContainer> containers = scanFusionStep.getHasContainers();
            if (!containers.isEmpty()) {
                String predicate = (String)PredicateExprTransformFactory.HAS_STEP.apply(scanFusionStep);
                params.setPredicate(predicate);
            }
            if ((coinStep = scanFusionStep.getCoinStep()) != null) {
                double probability = (Double)Utils.getFieldValue(CoinStep.class, coinStep, "probability");
                params.setSampleRatio(probability);
            }
            op.setParams(params);
            return op;
        }
    }
    ,
    HAS_STEP{

        @Override
        public InterOpBase apply(Step step) {
            SelectOp op = new SelectOp();
            List containers = ((HasStep)step).getHasContainers();
            if (!containers.isEmpty()) {
                op.setPredicate(new OpArg<Step, String>(step, PredicateExprTransformFactory.HAS_STEP));
            }
            return op;
        }
    }
    ,
    IS_STEP{

        @Override
        public InterOpBase apply(Step step) {
            SelectOp op = new SelectOp();
            op.setPredicate(new OpArg<Step, String>(step, PredicateExprTransformFactory.IS_STEP));
            return op;
        }
    }
    ,
    EXPAND_FUSION_STEP{

        @Override
        public InterOpBase apply(Step step) {
            List<HasContainer> containers;
            ExpandOp op = new ExpandOp();
            ExpandFusionStep expandFusionStep = (ExpandFusionStep)step;
            op.setDirection(new OpArg<VertexStep, FfiDirection>(expandFusionStep, s1 -> {
                Direction direction = s1.getDirection();
                switch (direction) {
                    case IN: {
                        return FfiDirection.In;
                    }
                    case BOTH: {
                        return FfiDirection.Both;
                    }
                    case OUT: {
                        return FfiDirection.Out;
                    }
                }
                throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "invalid direction type");
            }));
            op.setEdgeOpt(new OpArg<ExpandFusionStep, FfiExpandOpt>(expandFusionStep, s1 -> {
                if (s1.getExpandOpt() == FfiExpandOpt.Edge) {
                    return FfiExpandOpt.Edge;
                }
                if (s1.getExpandOpt() == FfiExpandOpt.Vertex) {
                    return FfiExpandOpt.Vertex;
                }
                return FfiExpandOpt.Degree;
            }));
            QueryParams params = new QueryParams();
            String[] labels = expandFusionStep.getEdgeLabels();
            if (labels.length > 0) {
                for (String label : labels) {
                    params.addTable(ArgUtils.asNameOrId(label));
                }
            }
            if (!(containers = expandFusionStep.getHasContainers()).isEmpty()) {
                String predicate = (String)PredicateExprTransformFactory.HAS_STEP.apply(expandFusionStep);
                params.setPredicate(predicate);
            }
            op.setParams(params);
            return op;
        }
    }
    ,
    LIMIT_STEP{

        @Override
        public InterOpBase apply(Step step) {
            RangeGlobalStep limitStep = (RangeGlobalStep)step;
            int lower = (int)limitStep.getLowRange();
            int upper = (int)limitStep.getHighRange();
            LimitOp op = new LimitOp();
            op.setLower(new OpArg(lower));
            op.setUpper(new OpArg(upper));
            return op;
        }
    }
    ,
    VALUES_STEP{

        @Override
        public InterOpBase apply(Step step) {
            ProjectOp op = new ProjectOp();
            String expr = TraversalParentTransformFactory.PROJECT_BY_STEP.getSubTraversalAsExpr(new ExprArg(Collections.singletonList(step))).getSingleExpr().get();
            op.setExprWithAlias(new OpArg<String, List>(expr, expr1 -> {
                FfiAlias.ByValue alias = ArgUtils.asNoneAlias();
                return Arrays.asList(Pair.with((Object)expr1, (Object)((Object)alias)));
            }));
            return op;
        }
    }
    ,
    UNFOLD_STEP{

        @Override
        public InterOpBase apply(Step step) {
            UnfoldStep unfoldStep = (UnfoldStep)step;
            UnfoldOp op = new UnfoldOp();
            op.setUnfoldTag(new OpArg(ArgUtils.asNoneAlias()));
            return op;
        }
    }
    ,
    AGGREGATE_STEP{

        @Override
        public InterOpBase apply(Step step) {
            int stepIdx = TraversalHelper.stepIndex((Step)step, (Traversal.Admin)step.getTraversal());
            GroupOp op = new GroupOp();
            op.setGroupByKeys(new OpArg(Collections.emptyList()));
            ArgAggFn aggFn = TraversalParentTransformFactory.GROUP_BY_STEP.getAggFn(step, stepIdx, 0);
            op.setGroupByValues(new OpArg(Collections.singletonList(aggFn)));
            FfiAlias.ByValue aggAlias = aggFn.getAlias();
            if (aggAlias != null && aggAlias.alias != null && aggAlias.alias.opt == FfiNameIdOpt.Name) {
                step.removeLabel(aggFn.getAlias().alias.name);
            }
            return op;
        }
    }
    ,
    PATH_EXPAND_STEP{

        @Override
        public InterOpBase apply(Step step) {
            PathExpandOp op = new PathExpandOp((ExpandOp)EXPAND_FUSION_STEP.apply(step));
            PathExpandStep pathStep = (PathExpandStep)step;
            op.setLower(new OpArg(pathStep.getLower()));
            op.setUpper(new OpArg(pathStep.getUpper()));
            if (pathStep.getUntilCondition() != null) {
                op.setUntilCondition(new OpArg(pathStep.getUntilCondition()));
            }
            op.setPathOpt(pathStep.getPathOpt());
            op.setResultOpt(pathStep.getResultOpt());
            return op;
        }
    }
    ,
    EDGE_VERTEX_STEP{

        @Override
        public InterOpBase apply(Step step) {
            EdgeVertexStep vertexStep = (EdgeVertexStep)step;
            GetVOp op = new GetVOp();
            op.setGetVOpt(new OpArg<EdgeVertexStep, FfiVOpt>(vertexStep, edgeVertexStep -> {
                Direction direction = edgeVertexStep.getDirection();
                switch (direction) {
                    case OUT: {
                        return FfiVOpt.Start;
                    }
                    case IN: {
                        return FfiVOpt.End;
                    }
                    case BOTH: {
                        return FfiVOpt.Both;
                    }
                }
                throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, direction + " cannot be converted to FfiVOpt");
            }));
            op.setParams(new QueryParams());
            return op;
        }
    }
    ,
    EDGE_OTHER_STEP{

        @Override
        public InterOpBase apply(Step step) {
            EdgeOtherVertexStep otherStep = (EdgeOtherVertexStep)step;
            GetVOp op = new GetVOp();
            op.setGetVOpt(new OpArg<EdgeOtherVertexStep, FfiVOpt>(otherStep, otherStep1 -> FfiVOpt.Other));
            op.setParams(new QueryParams());
            return op;
        }
    }
    ,
    WHERE_START_STEP{

        @Override
        public InterOpBase apply(Step step) {
            WhereTraversalStep.WhereStartStep startStep = (WhereTraversalStep.WhereStartStep)step;
            String selectKey = (String)startStep.getScopeKeys().iterator().next();
            ProjectOp op = new ProjectOp();
            op.setExprWithAlias(new OpArg<String, List>(selectKey, key -> {
                String expr = "@" + selectKey;
                FfiAlias.ByValue alias = ArgUtils.asNoneAlias();
                return Collections.singletonList(Pair.with((Object)expr, (Object)((Object)alias)));
            }));
            return op;
        }
    }
    ,
    WHERE_END_STEP{

        @Override
        public InterOpBase apply(Step step) {
            WhereTraversalStep.WhereEndStep endStep = (WhereTraversalStep.WhereEndStep)step;
            SelectOp selectOp = new SelectOp();
            selectOp.setPredicate(new OpArg<Step, String>((Step)endStep, PredicateExprTransformFactory.WHERE_END_STEP));
            return selectOp;
        }
    }
    ,
    UNION_STEP{

        @Override
        public InterOpBase apply(Step step) {
            UnionOp unionOp = new UnionOp();
            unionOp.setSubOpCollectionList(new OpArg<UnionStep, List>((UnionStep)step, unionStep -> {
                List subTraversals = unionStep.getGlobalChildren();
                return subTraversals.stream().filter(k -> k != null).map(k -> new InterOpCollectionBuilder((Traversal)k).build()).collect(Collectors.toList());
            }));
            return unionOp;
        }
    }
    ,
    TRAVERSAL_MAP_STEP{

        @Override
        public InterOpBase apply(Step step) {
            Traversal.Admin mapTraversal;
            TraversalMapStep mapStep = (TraversalMapStep)step;
            Traversal.Admin admin = mapTraversal = mapStep.getLocalChildren().size() > 0 ? (Traversal.Admin)mapStep.getLocalChildren().get(0) : null;
            if (mapTraversal == null || mapTraversal instanceof IdentityTraversal || mapTraversal instanceof ValueTraversal) {
                Object defaultExpr = "@";
                FfiAlias.ByValue defaultAlias = ArgUtils.asNoneAlias();
                if (mapTraversal instanceof ValueTraversal) {
                    defaultExpr = "@." + ((ValueTraversal)mapTraversal).getPropertyKey();
                }
                ProjectOp op = new ProjectOp();
                op.setExprWithAlias(new OpArg(Collections.singletonList(Pair.with((Object)defaultExpr, (Object)((Object)defaultAlias)))));
                return op;
            }
            if (mapTraversal instanceof ColumnTraversal) {
                Column column = ((ColumnTraversal)mapTraversal).getColumn();
                switch (column) {
                    case keys: {
                        String key = this.getMapKey(mapStep);
                        SelectOneStep keySelect = new SelectOneStep(step.getTraversal(), Pop.last, key);
                        TraversalHelper.copyLabels((Step)mapStep, (Step)keySelect, (boolean)false);
                        return (InterOpBase)((List)TraversalParentTransformFactory.PROJECT_BY_STEP.apply(keySelect)).get(0);
                    }
                    case values: {
                        String value = this.getMapValue(mapStep);
                        SelectOneStep valueSelect = new SelectOneStep(step.getTraversal(), Pop.last, value);
                        TraversalHelper.copyLabels((Step)mapStep, (Step)valueSelect, (boolean)false);
                        return (InterOpBase)((List)TraversalParentTransformFactory.PROJECT_BY_STEP.apply(valueSelect)).get(0);
                    }
                }
                throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, column.name() + " is invalid");
            }
            throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "invalid map type " + mapTraversal.getClass());
        }

        private String getMapKey(TraversalMapStep step) {
            Step groupStep = this.getPreviousGroupStep((Step)step);
            int stepIdx = TraversalHelper.stepIndex((Step)groupStep, (Traversal.Admin)groupStep.getTraversal());
            return AliasManager.getAliasName(new AliasArg(AliasPrefixType.GROUP_KEYS, stepIdx));
        }

        private String getMapValue(TraversalMapStep step) {
            Step groupStep = this.getPreviousGroupStep((Step)step);
            int stepIdx = TraversalHelper.stepIndex((Step)groupStep, (Traversal.Admin)groupStep.getTraversal());
            return AliasManager.getAliasName(new AliasArg(AliasPrefixType.GROUP_VALUES, stepIdx));
        }

        private Step getPreviousGroupStep(Step step) {
            Step previous = step.getPreviousStep();
            while (!(previous instanceof EmptyStep || previous instanceof GroupStep || previous instanceof GroupCountStep)) {
                previous = previous.getPreviousStep();
            }
            if (!(previous instanceof EmptyStep)) {
                return previous;
            }
            TraversalParent parent = step.getTraversal().getParent();
            if (!(parent instanceof EmptyStep)) {
                return this.getPreviousGroupStep(parent.asStep());
            }
            throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "select keys or values should follow a group");
        }
    }
    ,
    MATCH_STEP{

        @Override
        public InterOpBase apply(Step step) {
            MatchStep matchStep = (MatchStep)step;
            MatchOp matchOp = new MatchOp();
            List<MatchSentence> sentences = this.getSentences(matchStep);
            matchOp.setSentences(new OpArg(sentences));
            return matchOp;
        }

        private List<MatchSentence> getSentences(MatchStep matchStep) {
            List matchTraversals = matchStep.getGlobalChildren();
            ArrayList<MatchSentence> sentences = new ArrayList<MatchSentence>();
            matchTraversals.forEach(traversal -> {
                ArrayList<Step> binderSteps = new ArrayList<Step>();
                Optional<String> startTag = Optional.empty();
                Optional<String> endTag = Optional.empty();
                FfiJoinKind joinKind = FfiJoinKind.Inner;
                for (Object o : traversal.getSteps()) {
                    Step s = (Step)o;
                    if (s instanceof MatchStep.MatchStartStep) {
                        Optional<String> selectKey = ((MatchStep.MatchStartStep)s).getSelectKey();
                        if (startTag.isPresent() || !selectKey.isPresent()) continue;
                        startTag = selectKey;
                        continue;
                    }
                    if (s instanceof MatchStep.MatchEndStep) {
                        Optional<String> matchKey = ((MatchStep.MatchEndStep)s).getMatchKey();
                        if (endTag.isPresent() || !matchKey.isPresent()) continue;
                        endTag = matchKey;
                        continue;
                    }
                    if (s instanceof WhereTraversalStep && binderSteps.isEmpty()) {
                        Traversal.Admin whereTraversal;
                        List children = ((WhereTraversalStep)s).getLocalChildren();
                        Traversal.Admin admin = whereTraversal = children.isEmpty() ? null : (Traversal.Admin)children.get(0);
                        if (whereTraversal != null && whereTraversal.getSteps().size() == 1 && whereTraversal.getStartStep() instanceof NotStep) {
                            NotStep notStep = (NotStep)whereTraversal.getStartStep();
                            List notChildren = notStep.getLocalChildren();
                            whereTraversal = notChildren.isEmpty() ? null : (Traversal.Admin)notChildren.get(0);
                            joinKind = FfiJoinKind.Anti;
                        } else {
                            joinKind = FfiJoinKind.Semi;
                        }
                        if (whereTraversal == null) continue;
                        for (Object o1 : whereTraversal.getSteps()) {
                            Set scopeKeys;
                            Step s1 = (Step)o1;
                            if (s1 instanceof WhereTraversalStep.WhereStartStep) {
                                if (startTag.isPresent() || (scopeKeys = ((WhereTraversalStep.WhereStartStep)s1).getScopeKeys()).isEmpty()) continue;
                                startTag = Optional.of((String)scopeKeys.iterator().next());
                                continue;
                            }
                            if (s1 instanceof WhereTraversalStep.WhereEndStep) {
                                if (endTag.isPresent() || (scopeKeys = ((WhereTraversalStep.WhereEndStep)s1).getScopeKeys()).isEmpty()) continue;
                                endTag = Optional.of((String)scopeKeys.iterator().next());
                                continue;
                            }
                            if (this.isValidBinderStep(s1)) {
                                binderSteps.add(s1);
                                continue;
                            }
                            throw new OpArgIllegalException(OpArgIllegalException.Cause.UNSUPPORTED_TYPE, s1.getClass() + " is unsupported yet in match");
                        }
                        continue;
                    }
                    if (this.isValidBinderStep(s)) {
                        binderSteps.add(s);
                        continue;
                    }
                    throw new OpArgIllegalException(OpArgIllegalException.Cause.UNSUPPORTED_TYPE, s.getClass() + " is unsupported yet in match");
                }
                if (!startTag.isPresent() || !endTag.isPresent()) {
                    throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "startTag or endTag not exist in match");
                }
                Traversal binderTraversal = (Traversal)GremlinAntlrToJava.getTraversalSupplier().get();
                binderSteps.forEach(b -> binderTraversal.asAdmin().addStep(b));
                InterOpCollection ops = new InterOpCollectionBuilder(binderTraversal).build();
                sentences.add(new MatchSentence((String)startTag.get(), (String)endTag.get(), ops, joinKind));
            });
            return sentences;
        }

        private boolean isValidBinderStep(Step step) {
            return step instanceof VertexStep || step instanceof PathExpandStep || step instanceof EdgeOtherVertexStep || step instanceof EdgeVertexStep || step instanceof HasStep;
        }
    }
    ,
    EXPR_STEP{

        @Override
        public InterOpBase apply(Step step) {
            ExprStep exprStep = (ExprStep)step;
            switch (exprStep.getType()) {
                case PROJECTION: {
                    ProjectOp projectOp = new ProjectOp();
                    projectOp.setExprWithAlias(new OpArg<String, List>(exprStep.getExpr(), expr -> Arrays.asList(Pair.with((Object)expr, (Object)((Object)ArgUtils.asNoneAlias())))));
                    return projectOp;
                }
            }
            SelectOp selectOp = new SelectOp();
            selectOp.setPredicate(new OpArg(exprStep.getExpr()));
            return selectOp;
        }
    }
    ,
    SUBGRAPH_STEP{

        @Override
        public InterOpBase apply(Step step) {
            SubgraphStep subgraphStep = (SubgraphStep)step;
            SubGraphAsUnionOp op = new SubGraphAsUnionOp(this.getConfigs(subgraphStep));
            Traversal.Admin getETraversal = (Traversal.Admin)GremlinAntlrToJava.getTraversalSupplier().get();
            getETraversal.addStep((Step)new IdentityStep(getETraversal));
            InterOpCollection getEOps = new InterOpCollectionBuilder((Traversal)getETraversal).build();
            Traversal.Admin getVTraversal = (Traversal.Admin)GremlinAntlrToJava.getTraversalSupplier().get();
            getVTraversal.addStep((Step)new EdgeVertexStep(getVTraversal, Direction.BOTH));
            getVTraversal.addStep((Step)new DedupGlobalStep(getVTraversal, new String[0]));
            InterOpCollection getVOps = new InterOpCollectionBuilder((Traversal)getVTraversal).build();
            List<InterOpCollection> subGraphOps = Arrays.asList(getEOps, getVOps);
            op.setSubOpCollectionList(new OpArg(subGraphOps));
            return op;
        }

        private Map<String, String> getConfigs(SubgraphStep step) {
            String meta = step.getSideEffectKey();
            return ImmutableMap.of((Object)"name", (Object)meta);
        }
    }
    ,
    IDENTITY_STEP{

        @Override
        public InterOpBase apply(Step step) {
            return new AsNoneOp();
        }
    }
    ,
    CONSTANT_STEP{

        @Override
        public InterOpBase apply(Step step) {
            Object value = ((ConstantStep)step).getConstant();
            String expr = PredicateExprTransformFactory.IS_STEP.getPredicateValue(value);
            ProjectOp projectOp = new ProjectOp();
            projectOp.setExprWithAlias(new OpArg(Collections.singletonList(Pair.with((Object)expr, (Object)((Object)ArgUtils.asNoneAlias())))));
            return projectOp;
        }
    }
    ,
    COIN_STEP{

        @Override
        public InterOpBase apply(Step step) {
            CoinStep coinStep = (CoinStep)step;
            double probability = (Double)Utils.getFieldValue(CoinStep.class, coinStep, "probability");
            SampleOp sampleOp = new SampleOp(SampleOp.RatioType.create(probability), this.getSeed(coinStep), ArgUtils.asNoneVar());
            return sampleOp;
        }

        private long getSeed(CoinStep step) {
            Random random = (Random)Utils.getFieldValue(CoinStep.class, step, "random");
            AtomicLong seed = (AtomicLong)Utils.getFieldValue(Random.class, random, "seed");
            return seed.get();
        }
    };

    protected Function<GraphStep, FfiScanOpt> SCAN_OPT = s1 -> {
        if (s1.returnsVertex()) {
            return FfiScanOpt.Entity;
        }
        return FfiScanOpt.Relation;
    };
    protected Function<GraphStep, List<FfiConst.ByValue>> CONST_IDS_FROM_STEP = s1 -> Arrays.stream(s1.getIds()).map(id -> {
        if (id instanceof Integer) {
            return ArgUtils.asConst((Integer)id);
        }
        if (id instanceof Long) {
            return ArgUtils.asConst((Long)id);
        }
        if (id instanceof BigInteger) {
            return ArgUtils.asConst(((BigInteger)id).longValue());
        }
        throw new OpArgIllegalException(OpArgIllegalException.Cause.UNSUPPORTED_TYPE, "can not convert const [" + id + "] to any type of FfiConst");
    }).collect(Collectors.toList());
    protected Function<ScanFusionStep, List<FfiNameOrId.ByValue>> LABELS_FROM_STEP = step -> {
        List<String> labels = step.getGraphLabels();
        return labels.stream().map(k -> ArgUtils.asNameOrId(k)).collect(Collectors.toList());
    };
}

