/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.transform;

import com.alibaba.graphscope.common.exception.OpArgIllegalException;
import com.alibaba.graphscope.common.intermediate.ArgAggFn;
import com.alibaba.graphscope.common.intermediate.ArgUtils;
import com.alibaba.graphscope.common.intermediate.ArgVariable;
import com.alibaba.graphscope.common.intermediate.operator.InterOpBase;
import com.alibaba.graphscope.common.intermediate.operator.ProjectOp;
import com.alibaba.graphscope.common.jna.type.FfiAggOpt;
import com.alibaba.graphscope.common.jna.type.FfiAlias;
import com.alibaba.graphscope.common.jna.type.FfiVariable;
import com.alibaba.graphscope.gremlin.transform.ExprArg;
import com.alibaba.graphscope.gremlin.transform.ExprResult;
import com.alibaba.graphscope.gremlin.transform.StepTransformFactory;
import com.alibaba.graphscope.gremlin.transform.alias.AliasArg;
import com.alibaba.graphscope.gremlin.transform.alias.AliasManager;
import com.alibaba.graphscope.gremlin.transform.alias.AliasPrefixType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.IdentityTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DedupGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WhereTraversalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ElementMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FoldStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.IdStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LabelStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MaxGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MeanGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MinGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectOneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SumGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TraversalMapStep;
import org.apache.tinkerpop.gremlin.structure.T;
import org.javatuples.Pair;

public interface TraversalParentTransform
extends Function<TraversalParent, List<InterOpBase>> {
    default public ExprResult getSubTraversalAsExpr(ExprArg exprArg) {
        int size = exprArg.size();
        ExprResult defaultNonExpr = new ExprResult().addTagExpr("", Optional.empty());
        if (size <= 1) {
            if (exprArg.isEmpty()) {
                return new ExprResult().addTagExpr("", Optional.of("@"));
            }
            Step step = exprArg.getStartStep();
            if (step instanceof PropertyMapStep) {
                String[] mapKeys = ((PropertyMapStep)step).getPropertyKeys();
                if (mapKeys.length > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("{");
                    for (int i = 0; i < mapKeys.length; ++i) {
                        if (i > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append("@." + mapKeys[i]);
                    }
                    stringBuilder.append("}");
                    return new ExprResult().addTagExpr("", Optional.of(stringBuilder.toString()));
                }
                return new ExprResult().addTagExpr("", Optional.of("@." + ArgUtils.PROPERTY_ALL));
            }
            if (step instanceof PropertiesStep) {
                String[] mapKeys = ((PropertiesStep)step).getPropertyKeys();
                if (mapKeys.length == 0) {
                    throw new OpArgIllegalException(OpArgIllegalException.Cause.UNSUPPORTED_TYPE, "values() is unsupported");
                }
                if (mapKeys.length > 1) {
                    throw new OpArgIllegalException(OpArgIllegalException.Cause.UNSUPPORTED_TYPE, "use valueMap(..) instead if there are multiple project keys");
                }
                return new ExprResult().addTagExpr("", Optional.of("@." + mapKeys[0]));
            }
            if (step instanceof LabelStep) {
                return new ExprResult().addTagExpr("", Optional.of("@." + T.label.getAccessor()));
            }
            if (step instanceof IdStep) {
                return new ExprResult().addTagExpr("", Optional.of("@." + T.id.getAccessor()));
            }
            if (step instanceof ElementMapStep) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("{");
                stringBuilder.append("@." + ArgUtils.ID + ",");
                stringBuilder.append("@." + ArgUtils.LABEL + ",");
                String[] mapKeys = ((ElementMapStep)step).getPropertyKeys();
                if (mapKeys.length > 0) {
                    for (int i = 0; i < mapKeys.length; ++i) {
                        if (i > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append("@." + mapKeys[i]);
                    }
                } else {
                    stringBuilder.append("@." + ArgUtils.PROPERTY_ALL);
                }
                stringBuilder.append("}");
                return new ExprResult().addTagExpr("", Optional.of(stringBuilder.toString()));
            }
            if (step instanceof SelectOneStep || step instanceof SelectStep) {
                Map<String, Traversal.Admin> selectBys = this.getProjectTraversals((TraversalParent)step);
                ExprResult exprRes = new ExprResult();
                for (Map.Entry<String, Traversal.Admin> entry : selectBys.entrySet()) {
                    String k = entry.getKey();
                    Traversal.Admin v = entry.getValue();
                    Optional<String> byExpr = this.getSubTraversalAsExpr(new ExprArg(v)).getSingleExpr();
                    if (byExpr.isPresent()) {
                        String expr = byExpr.get().replace("@", "@" + k);
                        exprRes.addTagExpr(k, Optional.of(expr));
                        continue;
                    }
                    exprRes.addTagExpr(k, Optional.empty());
                }
                return exprRes;
            }
            if (step instanceof WhereTraversalStep.WhereStartStep) {
                WhereTraversalStep.WhereStartStep startStep = (WhereTraversalStep.WhereStartStep)step;
                String selectKey = (String)startStep.getScopeKeys().iterator().next();
                return new ExprResult().addTagExpr(selectKey, Optional.of("@" + selectKey));
            }
            if (step instanceof TraversalMapStep) {
                ProjectOp mapOp = (ProjectOp)StepTransformFactory.TRAVERSAL_MAP_STEP.apply(step);
                List pairs = (List)mapOp.getExprWithAlias().get().applyArg();
                String mapExpr = (String)((Pair)pairs.get(0)).getValue0();
                String mapKey = mapExpr.substring(1);
                return new ExprResult().addTagExpr(mapKey, Optional.of(mapExpr));
            }
            if (step instanceof DedupGlobalStep) {
                ExprResult exprRes = new ExprResult();
                DedupGlobalStep dedupStep = (DedupGlobalStep)step;
                List traversals = dedupStep.getLocalChildren();
                IdentityTraversal dedupTraversal = traversals.isEmpty() ? new IdentityTraversal() : (Traversal.Admin)traversals.get(0);
                Optional<String> exprOpt = this.getSubTraversalAsExpr(new ExprArg((Traversal.Admin)dedupTraversal)).getSingleExpr();
                Set dedupKeys = dedupStep.getScopeKeys().isEmpty() ? Collections.singleton("") : dedupStep.getScopeKeys();
                for (String key : dedupKeys) {
                    if (exprOpt.isPresent()) {
                        String expr = exprOpt.get().replace("@", "@" + key);
                        exprRes.addTagExpr(key, Optional.of(expr));
                        continue;
                    }
                    exprRes.addTagExpr(key, Optional.empty());
                }
                return exprRes;
            }
            return defaultNonExpr;
        }
        if (size == 2) {
            Step startStep = exprArg.getStartStep();
            Step endStep = exprArg.getEndStep();
            if ((startStep instanceof SelectOneStep || startStep instanceof TraversalMapStep) && (endStep instanceof PropertiesStep || endStep instanceof PropertyMapStep)) {
                Optional<String> propertyExpr = this.getSubTraversalAsExpr(new ExprArg(Collections.singletonList(endStep))).getSingleExpr();
                if (!propertyExpr.isPresent()) {
                    return defaultNonExpr;
                }
                String selectKey = null;
                if (startStep instanceof SelectOneStep) {
                    selectKey = (String)((SelectOneStep)startStep).getScopeKeys().iterator().next();
                } else if (startStep instanceof TraversalMapStep) {
                    ProjectOp mapOp = (ProjectOp)StepTransformFactory.TRAVERSAL_MAP_STEP.apply(startStep);
                    List pairs = (List)mapOp.getExprWithAlias().get().applyArg();
                    String mapExpr = (String)((Pair)pairs.get(0)).getValue0();
                    selectKey = mapExpr.substring(1);
                }
                String expr = propertyExpr.get().replace("@", "@" + selectKey);
                return new ExprResult().addTagExpr(selectKey, Optional.of(expr));
            }
            return defaultNonExpr;
        }
        return defaultNonExpr;
    }

    default public FfiVariable.ByValue getExpressionAsVar(String expr) {
        if (expr.startsWith("{") && expr.endsWith("}")) {
            throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "can not convert expression of valueMap to variable");
        }
        String[] splitExpr = expr.split("\\.");
        if (splitExpr.length == 0) {
            throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "expr " + expr + " is invalid");
        }
        String tag = splitExpr[0].length() > 0 ? splitExpr[0].substring(1) : splitExpr[0];
        String property = splitExpr.length > 1 ? splitExpr[1] : "";
        return ArgUtils.asVar(tag, property);
    }

    default public ArgVariable getExpressionAsArgVar(String expr) {
        if (expr.startsWith("{") && expr.endsWith("}")) {
            throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "can not convert expression of valueMap to variable");
        }
        String[] splitExpr = expr.split("\\.");
        if (splitExpr.length == 0) {
            throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "expr " + expr + " is invalid");
        }
        String tag = splitExpr[0].length() > 0 ? splitExpr[0].substring(1) : splitExpr[0];
        String property = splitExpr.length > 1 ? splitExpr[1] : "";
        return new ArgVariable(tag, property);
    }

    default public Map<String, Traversal.Admin> getProjectTraversals(TraversalParent parent) {
        if (parent instanceof SelectOneStep) {
            SelectOneStep step = (SelectOneStep)parent;
            Traversal.Admin selectTraversal = null;
            List byTraversals = step.getLocalChildren();
            if (!byTraversals.isEmpty()) {
                selectTraversal = (Traversal.Admin)byTraversals.get(0);
            }
            String selectKey = (String)step.getScopeKeys().iterator().next();
            HashMap<String, Traversal.Admin> selectOneByTraversal = new HashMap<String, Traversal.Admin>();
            selectOneByTraversal.put(selectKey, selectTraversal);
            return selectOneByTraversal;
        }
        if (parent instanceof SelectStep) {
            SelectStep step = (SelectStep)parent;
            return step.getByTraversals();
        }
        throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "cannot get project traversals from " + parent.getClass());
    }

    default public ArgAggFn getAggFn(Step step, int stepIdx, int subId) {
        FfiAlias.ByValue alias;
        FfiAggOpt aggOpt;
        if (step instanceof CountGlobalStep) {
            aggOpt = FfiAggOpt.Count;
        } else if (step instanceof FoldStep) {
            aggOpt = FfiAggOpt.ToList;
        } else if (step instanceof SumGlobalStep) {
            aggOpt = FfiAggOpt.Sum;
        } else if (step instanceof MinGlobalStep) {
            aggOpt = FfiAggOpt.Min;
        } else if (step instanceof MaxGlobalStep) {
            aggOpt = FfiAggOpt.Max;
        } else if (step instanceof MeanGlobalStep) {
            aggOpt = FfiAggOpt.Avg;
        } else {
            throw new OpArgIllegalException(OpArgIllegalException.Cause.UNSUPPORTED_TYPE, "invalid aggFn " + step.getClass());
        }
        Set labels = step.getLabels();
        if (labels != null && !labels.isEmpty()) {
            String label = (String)labels.iterator().next();
            alias = ArgUtils.asAlias(label, true);
        } else {
            alias = AliasManager.getFfiAlias(new AliasArg(AliasPrefixType.GROUP_VALUES, stepIdx, subId));
        }
        return new ArgAggFn(aggOpt, alias);
    }
}

