/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.transform.alias;

import com.alibaba.graphscope.gremlin.transform.alias.AliasPrefixType;

public class AliasArg {
    public static String GROUP_KEYS = "~keys";
    public static String GROUP_VALUES = "~values";
    public static String DEFAULT = "~alias";
    private String tag;
    private AliasPrefixType type;
    private int stepIdx;
    private int subTraversalIdx;

    private AliasArg() {
        this.tag = "";
        this.type = AliasPrefixType.DEFAULT;
        this.stepIdx = 0;
        this.subTraversalIdx = 0;
    }

    public AliasArg(AliasPrefixType type) {
        this.type = type;
    }

    public AliasArg(AliasPrefixType type, int stepIdx) {
        this(type);
        this.stepIdx = stepIdx;
    }

    public AliasArg(AliasPrefixType type, int stepIdx, int subTraversalIdx) {
        this(type, stepIdx);
        this.subTraversalIdx = subTraversalIdx;
    }

    public AliasArg(AliasPrefixType type, String tag) {
        if (tag.isEmpty()) {
            this.type = AliasPrefixType.DEFAULT;
        } else {
            this.tag = tag;
            this.type = type;
        }
    }

    public AliasArg(AliasPrefixType type, String tag, int stepIdx) {
        this(type, tag);
        this.stepIdx = stepIdx;
    }

    public AliasArg(AliasPrefixType type, String tag, int stepIdx, int subTraversalIdx) {
        this(type, tag, stepIdx);
        this.subTraversalIdx = subTraversalIdx;
    }

    public String getPrefix() {
        switch (this.type) {
            case PROJECT_TAG: {
                return this.tag;
            }
            case GROUP_KEYS: {
                return GROUP_KEYS;
            }
            case GROUP_VALUES: {
                return GROUP_VALUES;
            }
        }
        return DEFAULT;
    }

    public int getStepIdx() {
        return this.stepIdx;
    }

    public int getSubTraversalIdx() {
        return this.subTraversalIdx;
    }
}

