/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.alibaba.graphscope.common.ir.rex.RexCallBinding;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;

public abstract class GraphInferTypes {
    public static final SqlOperandTypeInference FIRST_KNOWN = (callBinding, returnType, operandTypes) -> {
        RexNode rexNode;
        RelDataType unknownType;
        Preconditions.checkArgument((boolean)(callBinding instanceof RexCallBinding));
        RelDataType knownType = unknownType = callBinding.getTypeFactory().createUnknownType();
        Iterator<RexNode> iterator = ((RexCallBinding)callBinding).getRexOperands().iterator();
        while (iterator.hasNext() && (knownType = (rexNode = iterator.next()).getType()).equals(unknownType)) {
        }
        Arrays.fill(operandTypes, knownType);
    };
    public static final SqlOperandTypeInference RETURN_TYPE = (callBinding, returnType, operandTypes) -> {
        RelDataType unknownType = callBinding.getTypeFactory().createUnknownType();
        for (int i = 0; i < operandTypes.length; ++i) {
            if (!operandTypes[i].equals(unknownType)) continue;
            operandTypes[i] = returnType.isStruct() ? ((RelDataTypeField)returnType.getFieldList().get(i)).getType() : returnType;
        }
    };
    public static final SqlOperandTypeInference IN_OPERANDS_TYPE = (callBinding, returnType, operandTypes) -> {
        RelDataType leftType = operandTypes[0];
        RelDataType rightType = operandTypes[1];
        RelDataType unknownType = callBinding.getTypeFactory().createUnknownType();
        if (leftType.equals(unknownType) && rightType.getSqlTypeName() == SqlTypeName.ARRAY) {
            operandTypes[0] = rightType.getComponentType();
        }
        if (rightType.equals(unknownType) && !leftType.equals(unknownType)) {
            operandTypes[1] = callBinding.getTypeFactory().createArrayType(leftType, -1L);
        }
    };

    private GraphInferTypes() {
    }
}

