/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.GraphFamilyOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphOperandMetaDataImpl
extends GraphFamilyOperandTypeChecker
implements SqlOperandMetadata {
    private final Function<RelDataTypeFactory, List<RelDataType>> paramTypesFactory;
    private final IntFunction<String> paramNameFn;

    GraphOperandMetaDataImpl(List<RelDataTypeFamily> expectedFamilies, Function<@Nullable RelDataTypeFactory, List<RelDataType>> paramTypesFactory, IntFunction<String> paramNameFn, Predicate<Integer> optional) {
        super(expectedFamilies, optional);
        this.paramTypesFactory = Objects.requireNonNull(paramTypesFactory, "paramTypesFactory");
        this.paramNameFn = paramNameFn;
    }

    @Override
    protected Collection<SqlTypeName> getAllowedTypeNames(RelDataTypeFactory typeFactory, SqlTypeFamily family, int iFormalOperand) {
        List<RelDataType> paramsAllowedTypes = this.paramTypes(typeFactory);
        if (paramsAllowedTypes.size() > iFormalOperand) {
            return ImmutableList.of((Object)paramsAllowedTypes.get(iFormalOperand).getSqlTypeName());
        }
        if (this.expectedFamilies.get(iFormalOperand) instanceof SqlTypeFamily) {
            return ((SqlTypeFamily)this.expectedFamilies.get(iFormalOperand)).getTypeNames();
        }
        throw new IllegalArgumentException("cannot find allowed type for type index=" + iFormalOperand + " from the allowed types list=" + paramsAllowedTypes + " or expected families=" + this.expectedFamilies);
    }

    public boolean isFixedParameters() {
        return true;
    }

    public List<RelDataType> paramTypes(@Nullable RelDataTypeFactory typeFactory) {
        return this.paramTypesFactory.apply(typeFactory);
    }

    public List<String> paramNames() {
        return Functions.generate((int)this.expectedFamilies.size(), this.paramNameFn);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        List<RelDataType> paramTypes = this.paramTypes(null);
        List signatureTypes = ObjectUtils.isEmpty(paramTypes) ? this.expectedFamilies : paramTypes.stream().map(k -> k.getSqlTypeName()).collect(Collectors.toList());
        return SqlUtil.getAliasedSignature((SqlOperator)op, (String)opName, signatureTypes);
    }
}

