/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import org.neo4j.consistency.checking.cache.CacheSlots;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class BatchedRelationshipRecords {
    private static final int FIELDS_PER_RELATIONSHIP = 8;
    private static final int BATCH_SIZE = 1000;
    private long[] fields = new long[8000];
    private int writeCursor;
    private int readCursor;

    BatchedRelationshipRecords() {
    }

    int numberOfRelationships() {
        return this.writeCursor / 8;
    }

    boolean hasMoreSpace() {
        return this.writeCursor < this.fields.length;
    }

    void add(RelationshipRecord relationshipRecord) {
        this.fields[this.writeCursor++] = relationshipRecord.getId();
        this.fields[this.writeCursor++] = relationshipRecord.getFirstNode();
        this.fields[this.writeCursor++] = relationshipRecord.getSecondNode();
        this.fields[this.writeCursor++] = relationshipRecord.getFirstPrevRel();
        this.fields[this.writeCursor++] = relationshipRecord.getFirstNextRel();
        this.fields[this.writeCursor++] = relationshipRecord.getSecondPrevRel();
        this.fields[this.writeCursor++] = relationshipRecord.getSecondNextRel();
        this.fields[this.writeCursor++] = CacheSlots.longOf(relationshipRecord.isFirstInFirstChain()) | CacheSlots.longOf(relationshipRecord.isFirstInSecondChain()) << 1;
    }

    boolean fillNext(RelationshipRecord relationshipRecord) {
        if (this.readCursor < this.writeCursor) {
            relationshipRecord.setId(this.fields[this.readCursor++]);
            relationshipRecord.setFirstNode(this.fields[this.readCursor++]);
            relationshipRecord.setSecondNode(this.fields[this.readCursor++]);
            relationshipRecord.setFirstPrevRel(this.fields[this.readCursor++]);
            relationshipRecord.setFirstNextRel(this.fields[this.readCursor++]);
            relationshipRecord.setSecondPrevRel(this.fields[this.readCursor++]);
            relationshipRecord.setSecondNextRel(this.fields[this.readCursor++]);
            long flags = this.fields[this.readCursor++];
            relationshipRecord.setFirstInFirstChain((flags & 1L) != 0L);
            relationshipRecord.setFirstInSecondChain((flags & 2L) != 0L);
            relationshipRecord.setInUse(true);
            return true;
        }
        return false;
    }
}

