/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.HashMap;
import java.util.Map;
import java.util.OptionalLong;
import java.util.function.Function;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checker.CheckerContext;
import org.neo4j.consistency.checker.ParallelExecution;
import org.neo4j.consistency.checker.RecordLoading;
import org.neo4j.consistency.checker.RecordReader;
import org.neo4j.consistency.checking.SchemaRuleKey;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.recordstorage.SchemaStorage;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaProcessor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.storemigration.legacy.SchemaRuleKind;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;

class SchemaChecker {
    private static final String CONSISTENCY_TOKEN_CHECKER_TAG = "consistencyTokenChecker";
    private final NeoStores neoStores;
    private final TokenHolders tokenHolders;
    private final IndexAccessors indexAccessors;
    private final CheckerContext context;
    private final SchemaStore schemaStore;
    private final ConsistencyReport.Reporter reporter;
    private final ParallelExecution execution;

    SchemaChecker(CheckerContext context) {
        this.neoStores = context.neoStores;
        this.tokenHolders = context.tokenHolders;
        this.indexAccessors = context.indexAccessors;
        this.context = context;
        this.schemaStore = this.neoStores.getSchemaStore();
        this.reporter = context.reporter;
        this.execution = context.execution;
    }

    void check(MutableIntObjectMap<MutableIntSet> mandatoryNodeProperties, MutableIntObjectMap<MutableIntSet> mandatoryRelationshipProperties, CursorContext cursorContext, StoreCursors storeCursors) throws Exception {
        this.checkSchema(mandatoryNodeProperties, mandatoryRelationshipProperties, cursorContext, storeCursors);
        this.checkTokens();
    }

    private void checkSchema(MutableIntObjectMap<MutableIntSet> mandatoryNodeProperties, MutableIntObjectMap<MutableIntSet> mandatoryRelationshipProperties, CursorContext cursorContext, StoreCursors storeCursors) {
        long highId = this.schemaStore.getHighId();
        try (RecordReader<SchemaRecord> schemaReader = new RecordReader<SchemaRecord>((CommonAbstractStore<SchemaRecord, ?>)this.schemaStore, true, cursorContext);){
            HashMap<Long, SchemaRecord> indexObligations = new HashMap<Long, SchemaRecord>();
            HashMap<Long, Pair<SchemaRecord, IndexType>> constraintObligations = new HashMap<Long, Pair<SchemaRecord, IndexType>>();
            HashMap<SchemaRuleKey, SchemaRecord> verifiedRulesWithRecords = new HashMap<SchemaRuleKey, SchemaRecord>();
            SchemaStorage schemaStorage = new SchemaStorage(this.schemaStore, this.tokenHolders, () -> KernelVersion.LATEST);
            this.buildObligationsMap(highId, schemaReader, schemaStorage, indexObligations, constraintObligations, verifiedRulesWithRecords, storeCursors);
            this.performSchemaCheck(highId, schemaReader, indexObligations, constraintObligations, schemaStorage, mandatoryNodeProperties, mandatoryRelationshipProperties, storeCursors);
        }
    }

    private void buildObligationsMap(long highId, RecordReader<SchemaRecord> reader, SchemaStorage schemaStorage, Map<Long, SchemaRecord> indexObligations, Map<Long, Pair<SchemaRecord, IndexType>> constraintObligations, Map<SchemaRuleKey, SchemaRecord> verifiedRulesWithRecords, StoreCursors storeCursors) {
        for (long id = (long)this.schemaStore.getNumberOfReservedLowIds(); id < highId && !this.context.isCancelled(); ++id) {
            try {
                Pair<SchemaRecord, IndexType> previousObligation;
                IndexDescriptor rule;
                SchemaRecord record = reader.read(id);
                if (!record.inUse()) continue;
                SchemaRule schemaRule = schemaStorage.loadSingleSchemaRule(id, storeCursors);
                SchemaRecord previousContentRecord = verifiedRulesWithRecords.put(SchemaRuleKey.from(schemaRule), record.copy());
                if (previousContentRecord != null) {
                    this.reporter.forSchema(record).duplicateRuleContent(previousContentRecord);
                }
                if (schemaRule instanceof IndexDescriptor) {
                    rule = (IndexDescriptor)schemaRule;
                    if (!rule.isUnique() || !rule.getOwningConstraintId().isPresent() || (previousObligation = constraintObligations.put(rule.getOwningConstraintId().getAsLong(), (Pair<SchemaRecord, IndexType>)Pair.of((Object)record.copy(), (Object)rule.getIndexType()))) == null) continue;
                    this.reporter.forSchema(record).duplicateObligation((SchemaRecord)previousObligation.first());
                    continue;
                }
                if (!(schemaRule instanceof ConstraintDescriptor) || !(rule = (ConstraintDescriptor)schemaRule).enforcesUniqueness() || (previousObligation = indexObligations.put(rule.asIndexBackedConstraint().ownedIndexId(), record.copy())) == null) continue;
                this.reporter.forSchema(record).duplicateObligation((SchemaRecord)previousObligation);
                continue;
            }
            catch (MalformedSchemaRuleException malformedSchemaRuleException) {
                // empty catch block
            }
        }
    }

    private void performSchemaCheck(long highId, RecordReader<SchemaRecord> reader, Map<Long, SchemaRecord> indexObligations, Map<Long, Pair<SchemaRecord, IndexType>> constraintObligations, SchemaStorage schemaStorage, MutableIntObjectMap<MutableIntSet> mandatoryNodeProperties, MutableIntObjectMap<MutableIntSet> mandatoryRelationshipProperties, StoreCursors storeCursors) {
        SchemaRecord record = reader.record();
        BasicSchemaCheck basicSchemaCheck = new BasicSchemaCheck(record, storeCursors);
        MandatoryPropertiesBuilder mandatoryPropertiesBuilder = new MandatoryPropertiesBuilder(mandatoryNodeProperties, mandatoryRelationshipProperties);
        for (long id = (long)this.schemaStore.getNumberOfReservedLowIds(); id < highId && !this.context.isCancelled(); ++id) {
            try {
                Pair<SchemaRecord, IndexType> obligation;
                IndexDescriptor rule;
                reader.read(id);
                if (!record.inUse()) continue;
                SchemaRule schemaRule = schemaStorage.loadSingleSchemaRule(id, storeCursors);
                schemaRule.schema().processWith((SchemaProcessor)basicSchemaCheck);
                if (schemaRule instanceof IndexDescriptor) {
                    rule = (IndexDescriptor)schemaRule;
                    if (rule.isUnique()) {
                        obligation = indexObligations.get(rule.getId());
                        if (obligation == null) {
                            if (rule.getOwningConstraintId().isPresent()) {
                                this.reporter.forSchema(record).missingObligation(SchemaRuleKind.UNIQUENESS_CONSTRAINT.name());
                            }
                        } else {
                            OptionalLong owningConstraintId = rule.getOwningConstraintId();
                            if (owningConstraintId.isEmpty() || obligation.getId() != owningConstraintId.getAsLong()) {
                                this.reporter.forSchema(record).constraintIndexRuleNotReferencingBack((SchemaRecord)obligation);
                            }
                        }
                    }
                    if (this.indexAccessors.notOnlineRules().contains(rule)) {
                        this.reporter.forSchema(record).schemaRuleNotOnline((SchemaRule)rule);
                    }
                    if (!this.indexAccessors.inconsistentRules().contains(rule)) continue;
                    this.reporter.forSchema(record).malformedSchemaRule();
                    continue;
                }
                if (schemaRule instanceof ConstraintDescriptor) {
                    rule = (ConstraintDescriptor)schemaRule;
                    if (rule.enforcesUniqueness()) {
                        obligation = constraintObligations.get(rule.getId());
                        if (obligation == null) {
                            this.reporter.forSchema(record).missingObligation(SchemaRuleKind.CONSTRAINT_INDEX_RULE.name());
                        } else if (((SchemaRecord)obligation.first()).getId() != rule.asIndexBackedConstraint().ownedIndexId()) {
                            this.reporter.forSchema(record).uniquenessConstraintNotReferencingBack((SchemaRecord)obligation.first());
                        } else if (obligation.other() != rule.asIndexBackedConstraint().indexType()) {
                            this.reporter.forSchema(record).uniquenessConstraintReferencingIndexOfWrongType((SchemaRecord)obligation.first());
                        }
                    }
                    if (!rule.enforcesPropertyExistence()) continue;
                    rule.schema().processWith((SchemaProcessor)mandatoryPropertiesBuilder);
                    continue;
                }
                this.reporter.forSchema(record).unsupportedSchemaRuleType(null);
                continue;
            }
            catch (MalformedSchemaRuleException e) {
                this.reporter.forSchema(record).malformedSchemaRule();
            }
        }
    }

    private void checkTokens() throws Exception {
        this.execution.run(this.getClass().getSimpleName() + "-checkTokens", () -> SchemaChecker.checkTokens(this.neoStores.getLabelTokenStore(), this.reporter::forLabelName, dynamicRecord -> this.reporter.forDynamicBlock(RecordType.LABEL_NAME, (DynamicRecord)dynamicRecord), this.context.pageCacheTracer), () -> SchemaChecker.checkTokens(this.neoStores.getRelationshipTypeTokenStore(), this.reporter::forRelationshipTypeName, dynamicRecord -> this.reporter.forDynamicBlock(RecordType.RELATIONSHIP_TYPE_NAME, (DynamicRecord)dynamicRecord), this.context.pageCacheTracer), () -> SchemaChecker.checkTokens(this.neoStores.getPropertyKeyTokenStore(), this.reporter::forPropertyKey, dynamicRecord -> this.reporter.forDynamicBlock(RecordType.PROPERTY_KEY_NAME, (DynamicRecord)dynamicRecord), this.context.pageCacheTracer));
    }

    private static <R extends TokenRecord> void checkTokens(TokenStore<R> store, Function<R, ConsistencyReport.NameConsistencyReport> report, Function<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> dynamicRecordReport, PageCacheTracer pageCacheTracer) {
        DynamicStringStore nameStore = store.getNameStore();
        DynamicRecord nameRecord = (DynamicRecord)nameStore.newRecord();
        long highId = store.getHighId();
        MutableLongSet seenNameRecordIds = LongSets.mutable.empty();
        int blockSize = store.getNameStore().getRecordDataSize();
        try (CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer(CONSISTENCY_TOKEN_CHECKER_TAG));
             RecordReader tokenReader = new RecordReader(store, true, cursorContext);
             RecordReader<DynamicRecord> nameReader = new RecordReader<DynamicRecord>((CommonAbstractStore<DynamicRecord, ?>)store.getNameStore(), false, cursorContext);){
            for (long id = 0L; id < highId; ++id) {
                TokenRecord record = (TokenRecord)tokenReader.read(id);
                if (!record.inUse() || Record.NULL_REFERENCE.is((long)record.getNameId())) continue;
                RecordLoading.safeLoadDynamicRecordChain(r -> {}, nameReader, seenNameRecordIds, record.getNameId(), blockSize, (i, r) -> ((ConsistencyReport.DynamicConsistencyReport)dynamicRecordReport.apply(nameRecord)).circularReferenceNext((DynamicRecord)r), (i, r) -> ((ConsistencyReport.NameConsistencyReport)report.apply(record)).nameBlockNotInUse(nameRecord), (i, r) -> ((ConsistencyReport.DynamicConsistencyReport)dynamicRecordReport.apply(nameRecord)).nextNotInUse((DynamicRecord)r), (i, r) -> ((ConsistencyReport.DynamicConsistencyReport)dynamicRecordReport.apply((DynamicRecord)r)).emptyBlock(), r -> ((ConsistencyReport.DynamicConsistencyReport)dynamicRecordReport.apply((DynamicRecord)r)).recordNotFullReferencesNext(), r -> ((ConsistencyReport.DynamicConsistencyReport)dynamicRecordReport.apply((DynamicRecord)r)).invalidLength());
            }
        }
    }

    private static class MandatoryPropertiesBuilder
    implements SchemaProcessor {
        private final MutableIntObjectMap<MutableIntSet> mandatoryNodeProperties;
        private final MutableIntObjectMap<MutableIntSet> mandatoryRelationshipProperties;

        MandatoryPropertiesBuilder(MutableIntObjectMap<MutableIntSet> mandatoryNodeProperties, MutableIntObjectMap<MutableIntSet> mandatoryRelationshipProperties) {
            this.mandatoryNodeProperties = mandatoryNodeProperties;
            this.mandatoryRelationshipProperties = mandatoryRelationshipProperties;
        }

        public void processSpecific(LabelSchemaDescriptor schema) {
            for (int entityToken : schema.getEntityTokenIds()) {
                MandatoryPropertiesBuilder.putMandatoryProperty(this.mandatoryNodeProperties, entityToken, schema.getPropertyIds());
            }
        }

        public void processSpecific(RelationTypeSchemaDescriptor schema) {
            MandatoryPropertiesBuilder.putMandatoryProperty(this.mandatoryRelationshipProperties, schema.getRelTypeId(), schema.getPropertyIds());
        }

        private static void putMandatoryProperty(MutableIntObjectMap<MutableIntSet> mandatoryProperties, int entityToken, int[] propertyIds) {
            MutableIntSet keys = (MutableIntSet)mandatoryProperties.get(entityToken);
            if (keys == null) {
                keys = new IntHashSet();
                mandatoryProperties.put(entityToken, (Object)keys);
            }
            keys.addAll(propertyIds);
        }

        public void processSpecific(SchemaDescriptor schema) {
            throw new UnsupportedOperationException();
        }
    }

    private class BasicSchemaCheck
    implements SchemaProcessor {
        private final SchemaRecord record;
        private final StoreCursors storeCursors;

        BasicSchemaCheck(SchemaRecord record, StoreCursors storeCursors) {
            this.record = record;
            this.storeCursors = storeCursors;
        }

        public void processSpecific(LabelSchemaDescriptor schema) {
            RecordLoading.checkValidInternalToken(null, schema.getLabelId(), SchemaChecker.this.tokenHolders.labelTokens(), SchemaChecker.this.neoStores.getLabelTokenStore(), (record, id) -> {}, (ignore, token) -> SchemaChecker.this.reporter.forSchema(this.record).labelNotInUse((LabelTokenRecord)token), this.storeCursors);
            this.checkValidPropertyKeyIds((SchemaDescriptor)schema);
        }

        public void processSpecific(RelationTypeSchemaDescriptor schema) {
            RecordLoading.checkValidInternalToken(null, schema.getRelTypeId(), SchemaChecker.this.tokenHolders.relationshipTypeTokens(), SchemaChecker.this.neoStores.getRelationshipTypeTokenStore(), (record, id) -> {}, (ignore, token) -> SchemaChecker.this.reporter.forSchema(this.record).relationshipTypeNotInUse((RelationshipTypeTokenRecord)token), this.storeCursors);
            this.checkValidPropertyKeyIds((SchemaDescriptor)schema);
        }

        public void processSpecific(SchemaDescriptor schema) {
            switch (schema.entityType()) {
                case NODE: {
                    for (int labelTokenId : schema.getEntityTokenIds()) {
                        RecordLoading.checkValidInternalToken(null, labelTokenId, SchemaChecker.this.tokenHolders.labelTokens(), SchemaChecker.this.neoStores.getLabelTokenStore(), (record, id) -> {}, (ignore, token) -> SchemaChecker.this.reporter.forSchema(this.record).labelNotInUse((LabelTokenRecord)token), this.storeCursors);
                    }
                    break;
                }
                case RELATIONSHIP: {
                    for (int relationshipTypeTokenId : schema.getEntityTokenIds()) {
                        RecordLoading.checkValidInternalToken(null, relationshipTypeTokenId, SchemaChecker.this.tokenHolders.relationshipTypeTokens(), SchemaChecker.this.neoStores.getRelationshipTypeTokenStore(), (record, id) -> {}, (ignore, token) -> SchemaChecker.this.reporter.forSchema(this.record).relationshipTypeNotInUse((RelationshipTypeTokenRecord)token), this.storeCursors);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Schema with given entity type is not supported: " + schema.entityType());
                }
            }
            this.checkValidPropertyKeyIds(schema);
        }

        private void checkValidPropertyKeyIds(SchemaDescriptor schema) {
            for (int propertyKeyId : schema.getPropertyIds()) {
                RecordLoading.checkValidInternalToken(null, propertyKeyId, SchemaChecker.this.tokenHolders.propertyKeyTokens(), SchemaChecker.this.neoStores.getPropertyKeyTokenStore(), (record, id) -> {}, (ignore, token) -> SchemaChecker.this.reporter.forSchema(this.record).propertyKeyNotInUse((PropertyKeyTokenRecord)token), this.storeCursors);
            }
        }
    }
}

