/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import org.neo4j.annotations.api.PublicApi;
import org.neo4j.annotations.service.Service;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParser;

@PublicApi
@Service
public abstract class GroupSetting {
    private final String name;

    protected GroupSetting(String name) {
        this.name = name;
    }

    public final String name() {
        return this.name;
    }

    public abstract String getPrefix();

    protected <T> SettingImpl.Builder<T> getBuilder(String suffix, SettingValueParser<T> parser, T defaultValue) {
        return SettingImpl.newBuilder(String.format("%s.%s.%s", this.getPrefix(), this.name, suffix), parser, defaultValue);
    }

    protected <T> SettingImpl.Builder<T> getBuilder(SettingValueParser<T> parser, T defaultValue) {
        return SettingImpl.newBuilder(String.format("%s.%s", this.getPrefix(), this.name), parser, defaultValue);
    }
}

