/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.database.readonly;

import java.util.Set;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.kernel.database.NamedDatabaseId;

public final class ConfigBasedLookupFactory
implements ReadOnlyDatabases.LookupFactory {
    private final Config config;

    public ConfigBasedLookupFactory(Config config) {
        this.config = config;
    }

    public ReadOnlyDatabases.Lookup lookupReadOnlyDatabases() {
        return new ConfigLookup(this.config.get(GraphDatabaseSettings.read_only_database_default), this.config.get(GraphDatabaseSettings.read_only_databases), this.config.get(GraphDatabaseSettings.writable_databases));
    }

    private static class ConfigLookup
    implements ReadOnlyDatabases.Lookup {
        private final boolean readOnlyDefault;
        private final Set<String> readOnlyDatabaseNames;
        private final Set<String> writableDatabaseNames;

        ConfigLookup(boolean readOnlyDefault, Set<String> readOnlyDatabaseNames, Set<String> writableDatabaseNames) {
            this.readOnlyDefault = readOnlyDefault;
            this.readOnlyDatabaseNames = readOnlyDatabaseNames;
            this.writableDatabaseNames = writableDatabaseNames;
        }

        public boolean databaseIsReadOnly(NamedDatabaseId databaseId) {
            String name = databaseId.name();
            boolean explicitlyReadOnly = this.readOnlyDatabaseNames.contains(name);
            boolean implicitlyReadOnly = this.readOnlyDefault && !this.writableDatabaseNames.contains(name);
            return explicitlyReadOnly || implicitlyReadOnly;
        }
    }
}

