/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.ext.ComponentAttributeProvider;
import org.jgrapht.ext.ComponentNameProvider;
import org.jgrapht.ext.ExportException;
import org.jgrapht.ext.GraphExporter;
import org.jgrapht.ext.IntegerComponentNameProvider;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GraphMLExporter<V, E>
implements GraphExporter<V, E> {
    private ComponentNameProvider<V> vertexIDProvider;
    private ComponentNameProvider<V> vertexLabelProvider;
    private ComponentNameProvider<E> edgeIDProvider;
    private ComponentNameProvider<E> edgeLabelProvider;
    private ComponentAttributeProvider<V> vertexAttributeProvider;
    private ComponentAttributeProvider<E> edgeAttributeProvider;
    private Map<String, AttributeDetails> registeredAttributes = new LinkedHashMap<String, AttributeDetails>();
    private static final String ATTRIBUTE_KEY_PREFIX = "key";
    private int totalAttributes = 0;
    private static final String VERTEX_LABEL_DEFAULT_ATTRIBUTE_NAME = "Vertex Label";
    private static final String EDGE_WEIGHT_DEFAULT_ATTRIBUTE_NAME = "weight";
    private static final String EDGE_LABEL_DEFAULT_ATTRIBUTE_NAME = "Edge Label";
    private String vertexLabelAttributeName = "Vertex Label";
    private String edgeWeightAttributeName = "weight";
    private String edgeLabelAttributeName = "Edge Label";
    private boolean exportEdgeWeights = false;

    public GraphMLExporter() {
        this(new IntegerComponentNameProvider(), null, null, new IntegerComponentNameProvider(), null, null);
    }

    public GraphMLExporter(ComponentNameProvider<V> vertexIDProvider, ComponentNameProvider<V> vertexLabelProvider, ComponentNameProvider<E> edgeIDProvider, ComponentNameProvider<E> edgeLabelProvider) {
        this(vertexIDProvider, vertexLabelProvider, null, edgeIDProvider, edgeLabelProvider, null);
    }

    public GraphMLExporter(ComponentNameProvider<V> vertexIDProvider, ComponentNameProvider<V> vertexLabelProvider, ComponentAttributeProvider<V> vertexAttributeProvider, ComponentNameProvider<E> edgeIDProvider, ComponentNameProvider<E> edgeLabelProvider, ComponentAttributeProvider<E> edgeAttributeProvider) {
        if (vertexIDProvider == null) {
            throw new IllegalArgumentException("Vertex ID provider must not be null");
        }
        this.vertexIDProvider = vertexIDProvider;
        this.vertexLabelProvider = vertexLabelProvider;
        this.vertexAttributeProvider = vertexAttributeProvider;
        if (edgeIDProvider == null) {
            throw new IllegalArgumentException("Edge ID provider must not be null");
        }
        this.edgeIDProvider = edgeIDProvider;
        this.edgeLabelProvider = edgeLabelProvider;
        this.edgeAttributeProvider = edgeAttributeProvider;
    }

    public void registerAttribute(String name, AttributeCategory category, AttributeType type) {
        this.registerAttribute(name, category, type, null);
    }

    public void registerAttribute(String name, AttributeCategory category, AttributeType type, String defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        if (name.equals(this.vertexLabelAttributeName) || name.equals(this.edgeWeightAttributeName) || name.equals(this.edgeLabelAttributeName)) {
            throw new IllegalArgumentException("Reserved attribute name");
        }
        if (category == null) {
            throw new IllegalArgumentException("Attribute category must be one of node, edge, graph or all");
        }
        String nextKey = ATTRIBUTE_KEY_PREFIX + this.totalAttributes++;
        this.registeredAttributes.put(name, new AttributeDetails(nextKey, category, type, defaultValue));
    }

    public void unregisterAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        if (name.equals(this.vertexLabelAttributeName) || name.equals(this.edgeWeightAttributeName) || name.equals(this.edgeLabelAttributeName)) {
            throw new IllegalArgumentException("Reserved attribute name");
        }
        this.registeredAttributes.remove(name);
    }

    public boolean isExportEdgeWeights() {
        return this.exportEdgeWeights;
    }

    public void setExportEdgeWeights(boolean exportEdgeWeights) {
        this.exportEdgeWeights = exportEdgeWeights;
    }

    public String getVertexLabelAttributeName() {
        return this.vertexLabelAttributeName;
    }

    public void setVertexLabelAttributeName(String vertexLabelAttributeName) {
        if (vertexLabelAttributeName == null) {
            throw new IllegalArgumentException("Vertex label attribute name cannot be null");
        }
        String key = vertexLabelAttributeName.trim();
        if (this.registeredAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Reserved attribute name");
        }
        this.vertexLabelAttributeName = key;
    }

    public String getEdgeLabelAttributeName() {
        return this.edgeLabelAttributeName;
    }

    public void setEdgeLabelAttributeName(String edgeLabelAttributeName) {
        if (edgeLabelAttributeName == null) {
            throw new IllegalArgumentException("Edge label attribute name cannot be null");
        }
        String key = edgeLabelAttributeName.trim();
        if (this.registeredAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Reserved attribute name");
        }
        this.edgeLabelAttributeName = key;
    }

    public String getEdgeWeightAttributeName() {
        return this.edgeWeightAttributeName;
    }

    public void setEdgeWeightAttributeName(String edgeWeightAttributeName) {
        if (edgeWeightAttributeName == null) {
            throw new IllegalArgumentException("Edge weight attribute name cannot be null");
        }
        String key = edgeWeightAttributeName.trim();
        if (this.registeredAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Reserved attribute name");
        }
        this.edgeWeightAttributeName = key;
    }

    public ComponentNameProvider<V> getVertexLabelProvider() {
        return this.vertexLabelProvider;
    }

    public void setVertexLabelProvider(ComponentNameProvider<V> vertexLabelProvider) {
        this.vertexLabelProvider = vertexLabelProvider;
    }

    public ComponentNameProvider<E> getEdgeLabelProvider() {
        return this.edgeLabelProvider;
    }

    public void setEdgeLabelProvider(ComponentNameProvider<E> edgeLabelProvider) {
        this.edgeLabelProvider = edgeLabelProvider;
    }

    public ComponentAttributeProvider<V> getVertexAttributeProvider() {
        return this.vertexAttributeProvider;
    }

    public void setVertexAttributeProvider(ComponentAttributeProvider<V> vertexAttributeProvider) {
        this.vertexAttributeProvider = vertexAttributeProvider;
    }

    public ComponentAttributeProvider<E> getEdgeAttributeProvider() {
        return this.edgeAttributeProvider;
    }

    public void setEdgeAttributeProvider(ComponentAttributeProvider<E> edgeAttributeProvider) {
        this.edgeAttributeProvider = edgeAttributeProvider;
    }

    @Override
    public void exportGraph(Graph<V, E> g, Writer writer) throws ExportException {
        try {
            SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler handler = factory.newTransformerHandler();
            handler.getTransformer().setOutputProperty("encoding", "UTF-8");
            handler.getTransformer().setOutputProperty("indent", "yes");
            handler.setResult(new StreamResult(new PrintWriter(writer)));
            handler.startDocument();
            this.writeHeader(handler);
            this.writeKeys(handler);
            this.writeGraphStart(handler, g);
            this.writeNodes(handler, g);
            this.writeEdges(handler, g);
            this.writeGraphEnd(handler);
            this.writeFooter(handler);
            handler.endDocument();
            writer.flush();
        }
        catch (Exception e) {
            throw new ExportException("Failed to export as GraphML", e);
        }
    }

    private void writeHeader(TransformerHandler handler) throws SAXException {
        handler.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        handler.endPrefixMapping("xsi");
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "", "xsi:schemaLocation", "CDATA", "http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd");
        handler.startElement("http://graphml.graphdrawing.org/xmlns", "", "graphml", attr);
    }

    private void writeGraphStart(TransformerHandler handler, Graph<V, E> g) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "", "edgedefault", "CDATA", g instanceof DirectedGraph ? "directed" : "undirected");
        handler.startElement("", "", "graph", attr);
    }

    private void writeGraphEnd(TransformerHandler handler) throws SAXException {
        handler.endElement("", "", "graph");
    }

    private void writeFooter(TransformerHandler handler) throws SAXException {
        handler.endElement("", "", "graphml");
    }

    private void writeKeys(TransformerHandler handler) throws SAXException {
        if (this.vertexLabelProvider != null) {
            this.writeAttribute(handler, this.vertexLabelAttributeName, new AttributeDetails("vertex_label_key", AttributeCategory.NODE, AttributeType.STRING, null));
        }
        if (this.edgeLabelProvider != null) {
            this.writeAttribute(handler, this.edgeLabelAttributeName, new AttributeDetails("edge_label_key", AttributeCategory.EDGE, AttributeType.STRING, null));
        }
        if (this.exportEdgeWeights) {
            this.writeAttribute(handler, this.edgeWeightAttributeName, new AttributeDetails("edge_weight_key", AttributeCategory.EDGE, AttributeType.DOUBLE, Double.toString(1.0)));
        }
        for (String attributeName : this.registeredAttributes.keySet()) {
            AttributeDetails details = this.registeredAttributes.get(attributeName);
            this.writeAttribute(handler, attributeName, details);
        }
    }

    private void writeData(TransformerHandler handler, String key, String value) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "", ATTRIBUTE_KEY_PREFIX, "CDATA", key);
        handler.startElement("", "", "data", attr);
        handler.characters(value.toCharArray(), 0, value.length());
        handler.endElement("", "", "data");
    }

    private void writeAttribute(TransformerHandler handler, String name, AttributeDetails details) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "", "id", "CDATA", details.key);
        attr.addAttribute("", "", "for", "CDATA", details.category.toString());
        attr.addAttribute("", "", "attr.name", "CDATA", name);
        attr.addAttribute("", "", "attr.type", "CDATA", details.type.toString());
        handler.startElement("", "", ATTRIBUTE_KEY_PREFIX, attr);
        if (details.defaultValue != null) {
            handler.startElement("", "", "default", null);
            handler.characters(details.defaultValue.toCharArray(), 0, details.defaultValue.length());
            handler.endElement("", "", "default");
        }
        handler.endElement("", "", ATTRIBUTE_KEY_PREFIX);
    }

    private void writeNodes(TransformerHandler handler, Graph<V, E> g) throws SAXException {
        for (Object v : g.vertexSet()) {
            String vertexLabel;
            AttributesImpl attr = new AttributesImpl();
            attr.addAttribute("", "", "id", "CDATA", this.vertexIDProvider.getName(v));
            handler.startElement("", "", "node", attr);
            if (this.vertexLabelProvider != null && (vertexLabel = this.vertexLabelProvider.getName(v)) != null) {
                this.writeData(handler, "vertex_label_key", vertexLabel);
            }
            Map<Object, Object> vertexAttributes = null;
            if (this.vertexAttributeProvider != null) {
                vertexAttributes = this.vertexAttributeProvider.getComponentAttributes(v);
            }
            if (vertexAttributes == null) {
                vertexAttributes = Collections.emptyMap();
            }
            for (Map.Entry<String, AttributeDetails> e : this.registeredAttributes.entrySet()) {
                AttributeDetails details = e.getValue();
                if (!details.category.equals((Object)AttributeCategory.NODE) && !details.category.equals((Object)AttributeCategory.ALL)) continue;
                String name = e.getKey();
                String defaultValue = details.defaultValue;
                if (!vertexAttributes.containsKey(name)) continue;
                String value = (String)vertexAttributes.get(name);
                if (defaultValue != null && defaultValue.equals(value) || value == null) continue;
                this.writeData(handler, details.key, value);
            }
            handler.endElement("", "", "node");
        }
    }

    private void writeEdges(TransformerHandler handler, Graph<V, E> g) throws SAXException {
        for (Object e : g.edgeSet()) {
            Double weight;
            String edgeLabel;
            AttributesImpl attr = new AttributesImpl();
            attr.addAttribute("", "", "id", "CDATA", this.edgeIDProvider.getName(e));
            attr.addAttribute("", "", "source", "CDATA", this.vertexIDProvider.getName(g.getEdgeSource(e)));
            attr.addAttribute("", "", "target", "CDATA", this.vertexIDProvider.getName(g.getEdgeTarget(e)));
            handler.startElement("", "", "edge", attr);
            if (this.edgeLabelProvider != null && (edgeLabel = this.edgeLabelProvider.getName(e)) != null) {
                this.writeData(handler, "edge_label_key", edgeLabel);
            }
            if (this.exportEdgeWeights && !(weight = Double.valueOf(g.getEdgeWeight(e))).equals(1.0)) {
                this.writeData(handler, "edge_weight_key", String.valueOf(weight));
            }
            Map<Object, Object> edgeAttributes = null;
            if (this.edgeAttributeProvider != null) {
                edgeAttributes = this.edgeAttributeProvider.getComponentAttributes(e);
            }
            if (edgeAttributes == null) {
                edgeAttributes = Collections.emptyMap();
            }
            for (Map.Entry<String, AttributeDetails> entry : this.registeredAttributes.entrySet()) {
                AttributeDetails details = entry.getValue();
                if (!details.category.equals((Object)AttributeCategory.EDGE) && !details.category.equals((Object)AttributeCategory.ALL)) continue;
                String name = entry.getKey();
                String defaultValue = details.defaultValue;
                if (!edgeAttributes.containsKey(name)) continue;
                String value = (String)edgeAttributes.get(name);
                if (defaultValue != null && defaultValue.equals(value) || value == null) continue;
                this.writeData(handler, details.key, value);
            }
            handler.endElement("", "", "edge");
        }
    }

    private class AttributeDetails {
        public String key;
        public AttributeCategory category;
        public AttributeType type;
        public String defaultValue;

        public AttributeDetails(String key, AttributeCategory category, AttributeType type, String defaultValue) {
            this.key = key;
            this.category = category;
            this.type = type;
            this.defaultValue = defaultValue;
        }
    }

    public static enum AttributeType {
        BOOLEAN("boolean"),
        INT("int"),
        LONG("long"),
        FLOAT("float"),
        DOUBLE("double"),
        STRING("string");

        private String name;

        private AttributeType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum AttributeCategory {
        GRAPH("graph"),
        NODE("node"),
        EDGE("edge"),
        ALL("all");

        private String name;

        private AttributeCategory(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

