/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.GroupSetting;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingObserver;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;

public class DatabaseConfig
extends Config
implements Lifecycle {
    private final Map<Setting<?>, Object> databaseSpecificSettings;
    private final Config globalConfig;
    private final Map<Setting<?>, Object> overriddenSettings;
    private Map<Setting<Object>, Collection<SettingChangeListener<Object>>> registeredListeners = new ConcurrentHashMap<Setting<Object>, Collection<SettingChangeListener<Object>>>();

    public DatabaseConfig(Map<Setting<?>, Object> databaseSpecificSettings, Config globalConfig, NamedDatabaseId namedDatabaseId) {
        this.databaseSpecificSettings = databaseSpecificSettings;
        this.globalConfig = globalConfig;
        this.overriddenSettings = !namedDatabaseId.isSystemDatabase() ? null : Map.of(GraphDatabaseSettings.record_format, "", GraphDatabaseSettings.allow_upgrade, Boolean.TRUE);
    }

    public <T> T get(Setting<T> setting) {
        Object o;
        if (this.overriddenSettings != null && (o = this.overriddenSettings.get(setting)) != null) {
            return (T)o;
        }
        Object dbSpecific = this.databaseSpecificSettings.get(setting);
        if (dbSpecific != null) {
            return (T)dbSpecific;
        }
        return (T)this.globalConfig.get(setting);
    }

    public <T> void addListener(Setting<T> setting, SettingChangeListener<T> listener) {
        this.registeredListeners.computeIfAbsent((Setting<Object>)((SettingImpl)setting), v -> new ConcurrentLinkedQueue()).add(listener);
        this.globalConfig.addListener(setting, listener);
    }

    public <T> void removeListener(Setting<T> setting, SettingChangeListener<T> listener) {
        Collection<SettingChangeListener<Object>> listeners = this.registeredListeners.get(setting);
        if (listeners != null) {
            listeners.remove(listener);
        }
        this.globalConfig.removeListener(setting, listener);
    }

    public void setLogger(Log internalLog) {
        this.globalConfig.setLogger(internalLog);
    }

    public <T extends GroupSetting> Map<String, T> getGroups(Class<T> group) {
        return this.globalConfig.getGroups(group);
    }

    public <T extends GroupSetting, U extends T> Map<Class<U>, Map<String, U>> getGroupsFromInheritance(Class<T> parentClass) {
        return this.globalConfig.getGroupsFromInheritance(parentClass);
    }

    public <T> SettingObserver<T> getObserver(Setting<T> setting) {
        return this.globalConfig.getObserver(setting);
    }

    public <T> void setDynamic(Setting<T> setting, T value, String scope) {
        this.globalConfig.setDynamic(setting, value, scope);
    }

    public <T> void set(Setting<T> setting, T value) {
        this.globalConfig.set(setting, value);
    }

    public <T> void setIfNotSet(Setting<T> setting, T value) {
        this.globalConfig.setIfNotSet(setting, value);
    }

    public boolean isExplicitlySet(Setting<?> setting) {
        return this.globalConfig.isExplicitlySet(setting);
    }

    public String toString() {
        return this.globalConfig.toString();
    }

    public Map<Setting<Object>, Object> getValues() {
        return this.globalConfig.getValues();
    }

    public Map<String, Setting<Object>> getDeclaredSettings() {
        return this.globalConfig.getDeclaredSettings();
    }

    public String toString(boolean includeNullValues) {
        return this.globalConfig.toString(includeNullValues);
    }

    public Setting<Object> getSetting(String name) {
        return this.globalConfig.getSetting(name);
    }

    public void init() {
    }

    public void start() {
    }

    public void stop() throws Exception {
        for (Map.Entry<Setting<Object>, Collection<SettingChangeListener<Object>>> settingListeners : this.registeredListeners.entrySet()) {
            Setting<Object> setting = settingListeners.getKey();
            Collection<SettingChangeListener<Object>> listeners = settingListeners.getValue();
            for (SettingChangeListener<Object> listener : listeners) {
                this.globalConfig.removeListener(setting, listener);
            }
        }
        this.registeredListeners = new ConcurrentHashMap<Setting<Object>, Collection<SettingChangeListener<Object>>>();
    }

    public void shutdown() {
    }
}

