/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.dbms.database.CommunityTopologyGraphDbmsModel;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;

public class SystemGraphDatabaseIdRepository
implements DatabaseIdRepository {
    private final Supplier<DatabaseContext> systemDatabaseSupplier;

    public SystemGraphDatabaseIdRepository(Supplier<DatabaseContext> systemDatabaseSupplier) {
        this.systemDatabaseSupplier = systemDatabaseSupplier;
    }

    @Override
    public Optional<NamedDatabaseId> getByName(NormalizedDatabaseName normalizedDatabaseName) {
        return this.execute(model -> model.getDatabaseIdByAlias(normalizedDatabaseName.name()));
    }

    @Override
    public Optional<NamedDatabaseId> getById(DatabaseId databaseId) {
        return this.execute(model -> model.getDatabaseIdByUUID(databaseId.uuid()));
    }

    @Override
    public Map<NormalizedDatabaseName, NamedDatabaseId> getAllDatabaseAliases() {
        Map aliases = this.execute(TopologyGraphDbmsModel::getAllDatabaseAliases);
        return aliases.entrySet().stream().map(e -> Map.entry(new NormalizedDatabaseName((String)e.getKey()), (NamedDatabaseId)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Set<NamedDatabaseId> getAllDatabaseIds() {
        return this.execute(TopologyGraphDbmsModel::getAllDatabaseIds);
    }

    private <T> T execute(Function<TopologyGraphDbmsModel, T> operation) {
        GraphDatabaseFacade systemDb = this.systemDatabaseSupplier.get().databaseFacade();
        try (Transaction tx = systemDb.beginTx();){
            CommunityTopologyGraphDbmsModel model = new CommunityTopologyGraphDbmsModel(tx);
            T t = operation.apply(model);
            return t;
        }
    }
}

