/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.index.internal.gbptree.Header;

class NativeIndexHeaderReader
implements Header.Reader {
    byte state;
    String failureMessage;
    private final byte failureByte;

    NativeIndexHeaderReader() {
        this(0);
    }

    NativeIndexHeaderReader(byte failureByte) {
        this.failureByte = failureByte;
    }

    public void read(ByteBuffer headerData) {
        try {
            this.state = headerData.get();
            if (this.state == this.failureByte) {
                this.failureMessage = NativeIndexHeaderReader.readFailureMessage(headerData);
            }
        }
        catch (BufferUnderflowException e) {
            this.state = this.failureByte;
            this.failureMessage = String.format("Could not read header, most likely caused by index not being fully constructed. Index needs to be recreated. Stacktrace:%n%s", ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private static String readFailureMessage(ByteBuffer headerData) {
        short messageLength = headerData.getShort();
        byte[] failureMessageBytes = new byte[messageLength];
        headerData.get(failureMessageBytes);
        return new String(failureMessageBytes, StandardCharsets.UTF_8);
    }
}

