/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.kernel.impl.index.schema.QueryValidator;
import org.neo4j.kernel.impl.index.schema.RangeIndexProvider;
import org.neo4j.kernel.impl.index.schema.RangeKey;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public class RangeIndexReader
extends NativeIndexReader<RangeKey> {
    RangeIndexReader(GBPTree<RangeKey, NullValue> tree, IndexLayout<RangeKey> layout, IndexDescriptor descriptor) {
        super(tree, layout, descriptor);
    }

    @Override
    void validateQuery(IndexQueryConstraints constraints, PropertyIndexQuery[] predicates) {
        RangeIndexReader.validateNoUnsupportedPredicates(predicates);
        QueryValidator.validateOrder(RangeIndexProvider.CAPABILITY, constraints.order(), predicates);
        QueryValidator.validateCompositeQuery(predicates);
    }

    @Override
    boolean initializeRangeForQuery(RangeKey treeKeyFrom, RangeKey treeKeyTo, PropertyIndexQuery[] predicates) {
        if (RangeIndexReader.isAllQuery(predicates)) {
            RangeIndexReader.initializeAllSlotsForFullRange(treeKeyFrom, treeKeyTo);
            return false;
        }
        block6: for (int i = 0; i < predicates.length; ++i) {
            PropertyIndexQuery predicate = predicates[i];
            switch (predicate.type()) {
                case EXISTS: {
                    treeKeyFrom.initValueAsLowest(i, ValueGroup.UNKNOWN);
                    treeKeyTo.initValueAsHighest(i, ValueGroup.UNKNOWN);
                    continue block6;
                }
                case EXACT: {
                    PropertyIndexQuery.ExactPredicate exactPredicate = (PropertyIndexQuery.ExactPredicate)predicate;
                    treeKeyFrom.initFromValue(i, exactPredicate.value(), NativeIndexKey.Inclusion.NEUTRAL);
                    treeKeyTo.initFromValue(i, exactPredicate.value(), NativeIndexKey.Inclusion.NEUTRAL);
                    continue block6;
                }
                case RANGE: {
                    RangeIndexReader.throwIfGeometryRangeQuery(predicates, predicate);
                    PropertyIndexQuery.RangePredicate rangePredicate = (PropertyIndexQuery.RangePredicate)predicate;
                    RangeIndexReader.initFromForRange(i, rangePredicate, treeKeyFrom);
                    RangeIndexReader.initToForRange(i, rangePredicate, treeKeyTo);
                    continue block6;
                }
                case STRING_PREFIX: {
                    PropertyIndexQuery.StringPrefixPredicate prefixPredicate = (PropertyIndexQuery.StringPrefixPredicate)predicate;
                    treeKeyFrom.stateSlot(i).initAsPrefixLow(prefixPredicate.prefix());
                    treeKeyTo.stateSlot(i).initAsPrefixHigh(prefixPredicate.prefix());
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("IndexQuery of type " + predicate.type() + " is not supported.");
                }
            }
        }
        return false;
    }

    private static boolean isAllQuery(PropertyIndexQuery[] predicates) {
        return predicates.length == 1 && predicates[0].type() == IndexQuery.IndexQueryType.ALL_ENTRIES;
    }

    private static void initializeAllSlotsForFullRange(RangeKey treeKeyFrom, RangeKey treeKeyTo) {
        assert (treeKeyFrom.numberOfStateSlots() == treeKeyTo.numberOfStateSlots());
        for (int i = 0; i < treeKeyFrom.numberOfStateSlots(); ++i) {
            treeKeyFrom.initValueAsLowest(i, ValueGroup.UNKNOWN);
            treeKeyTo.initValueAsHighest(i, ValueGroup.UNKNOWN);
        }
    }

    private static void initFromForRange(int stateSlot, PropertyIndexQuery.RangePredicate<?> rangePredicate, RangeKey treeKeyFrom) {
        Value fromValue = rangePredicate.fromValue();
        if (fromValue == Values.NO_VALUE) {
            treeKeyFrom.initValueAsLowest(stateSlot, rangePredicate.valueGroup());
        } else {
            treeKeyFrom.initFromValue(stateSlot, fromValue, RangeIndexReader.fromInclusion(rangePredicate));
            treeKeyFrom.setCompareId(true);
        }
    }

    private static void initToForRange(int stateSlot, PropertyIndexQuery.RangePredicate<?> rangePredicate, RangeKey treeKeyTo) {
        Value toValue = rangePredicate.toValue();
        if (toValue == Values.NO_VALUE) {
            treeKeyTo.initValueAsHighest(stateSlot, rangePredicate.valueGroup());
        } else {
            treeKeyTo.initFromValue(stateSlot, toValue, RangeIndexReader.toInclusion(rangePredicate));
            treeKeyTo.setCompareId(true);
        }
    }

    private static NativeIndexKey.Inclusion fromInclusion(PropertyIndexQuery.RangePredicate<?> rangePredicate) {
        return rangePredicate.fromInclusive() ? NativeIndexKey.Inclusion.LOW : NativeIndexKey.Inclusion.HIGH;
    }

    private static NativeIndexKey.Inclusion toInclusion(PropertyIndexQuery.RangePredicate<?> rangePredicate) {
        return rangePredicate.toInclusive() ? NativeIndexKey.Inclusion.HIGH : NativeIndexKey.Inclusion.LOW;
    }

    private static void validateNoUnsupportedPredicates(PropertyIndexQuery[] predicates) {
        for (PropertyIndexQuery predicate : predicates) {
            RangeIndexReader.throwIfGeometryRangeQuery(predicates, predicate);
            RangeIndexReader.throwIfStringSuffixOrContains(predicates, predicate);
        }
    }

    private static void throwIfGeometryRangeQuery(PropertyIndexQuery[] predicates, PropertyIndexQuery predicate) {
        if (predicate.type() == IndexQuery.IndexQueryType.RANGE && predicate.valueGroup() == ValueGroup.GEOMETRY) {
            throw new IllegalArgumentException(String.format("Tried to query index with illegal query. Geometry range predicate is not allowed for RANGE index. Query was: %s ", Arrays.toString(predicates)));
        }
    }

    private static void throwIfStringSuffixOrContains(PropertyIndexQuery[] predicates, PropertyIndexQuery predicate) {
        IndexQuery.IndexQueryType type = predicate.type();
        if (type == IndexQuery.IndexQueryType.STRING_SUFFIX || type == IndexQuery.IndexQueryType.STRING_CONTAINS) {
            throw new IllegalArgumentException(String.format("Tried to query index with illegal query. %s predicate is not allowed for RANGE index. Query was: %s ", type, Arrays.toString(predicates)));
        }
    }
}

