/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LayoutBootstrapper;
import org.neo4j.index.internal.gbptree.Meta;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.internal.id.indexed.IdRangeLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsLayout;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.TokenScanLayout;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;

public class SchemaLayouts
implements LayoutBootstrapper {
    private final List<LayoutBootstrapper> allSchemaLayout = new ArrayList<LayoutBootstrapper>();

    public SchemaLayouts() {
        this.allSchemaLayout.addAll(Arrays.asList(SchemaLayouts.genericLayout(), SchemaLayouts.idRangeLayout(), (indexFile, pageCache, meta) -> new TokenScanLayout(), (indexFile, pageCache, meta) -> new IndexStatisticsLayout()));
    }

    public static String[] layoutDescriptions() {
        return new String[]{"Generic layout", "Id range layout", "Label scan layout", "Index statistics layout"};
    }

    public Layout<?, ?> create(Path indexFile, PageCache pageCache, Meta meta) throws IOException {
        for (LayoutBootstrapper factory : this.allSchemaLayout) {
            Layout layout = factory.create(indexFile, pageCache, meta);
            if (layout == null || !SchemaLayouts.matchingLayout(meta, layout)) continue;
            return layout;
        }
        throw new RuntimeException("Could not find any layout matching meta " + meta);
    }

    private static boolean matchingLayout(Meta meta, Layout<?, ?> layout) {
        try {
            meta.verify(layout);
            return true;
        }
        catch (MetadataMismatchException e) {
            return false;
        }
    }

    private static LayoutBootstrapper genericLayout() {
        return (indexFile, pageCache, meta) -> {
            IndexSpecificSpaceFillingCurveSettings settings = IndexSpecificSpaceFillingCurveSettings.fromConfig(Config.defaults());
            int maxNumberOfSlots = 10;
            for (int numberOfSlots = 1; numberOfSlots < maxNumberOfSlots; ++numberOfSlots) {
                GenericLayout genericLayout = new GenericLayout(numberOfSlots, settings);
                if (!SchemaLayouts.matchingLayout(meta, genericLayout)) continue;
                return genericLayout;
            }
            return null;
        };
    }

    private static LayoutBootstrapper idRangeLayout() {
        return (indexFile, pageCache, meta) -> {
            int maxExponent = 10;
            for (int exponent = 0; exponent < maxExponent; ++exponent) {
                int idsPerEntry = 1 << exponent;
                IdRangeLayout idRangeLayout = new IdRangeLayout(idsPerEntry);
                if (!SchemaLayouts.matchingLayout(meta, idRangeLayout)) continue;
                return idRangeLayout;
            }
            return null;
        };
    }
}

