/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.EnumMap;
import java.util.function.Function;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;

class LazyInstanceSelector<T>
extends InstanceSelector<T> {
    private final Function<IndexSlot, T> factory;

    LazyInstanceSelector(Function<IndexSlot, T> factory) {
        this(new EnumMap(IndexSlot.class), factory);
    }

    LazyInstanceSelector(EnumMap<IndexSlot, T> map, Function<IndexSlot, T> factory) {
        super(map);
        this.factory = factory;
    }

    @Override
    T select(IndexSlot slot) {
        return (T)this.instances.computeIfAbsent(slot, s -> {
            this.assertOpen();
            return this.factory.apply((IndexSlot)((Object)s));
        });
    }

    T getIfInstantiated(IndexSlot slot) {
        return (T)this.instances.get((Object)slot);
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("This selector has been closed");
        }
    }
}

