/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query.clientconnection;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;

public class HttpConnectionInfo
extends ClientConnectionInfo {
    private final String connectionId;
    private final String protocol;
    private final SocketAddress clientAddress;
    private final SocketAddress serverAddress;
    private final String requestPath;

    public HttpConnectionInfo(String connectionId, String protocol, SocketAddress clientAddress, SocketAddress serverAddress, String requestPath) {
        this.connectionId = connectionId;
        this.protocol = protocol;
        this.clientAddress = clientAddress;
        this.serverAddress = serverAddress;
        this.requestPath = requestPath;
    }

    public String asConnectionDetails() {
        return String.join((CharSequence)"\t", "server-session", this.protocol, HttpConnectionInfo.getHostString(this.clientAddress), this.requestPath);
    }

    public String protocol() {
        return this.protocol;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String clientAddress() {
        return org.neo4j.configuration.helpers.SocketAddress.format((SocketAddress)this.clientAddress);
    }

    public String requestURI() {
        return this.serverAddress == null ? this.requestPath : this.protocol + "://" + org.neo4j.configuration.helpers.SocketAddress.format((SocketAddress)this.serverAddress) + this.requestPath;
    }

    private static String getHostString(SocketAddress address) {
        return address instanceof InetSocketAddress ? ((InetSocketAddress)address).getHostString() : address.toString();
    }
}

