/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.shape;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.shape.mxImageShape;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.Map;

public class mxLabelShape
extends mxImageShape {
    public void paintShape(mxGraphics2DCanvas canvas, mxCellState state) {
        super.paintShape(canvas, state);
        if (mxUtils.isTrue(state.getStyle(), mxConstants.STYLE_GLASS, false)) {
            mxLabelShape.drawGlassEffect(canvas, state);
        }
    }

    public static void drawGlassEffect(mxGraphics2DCanvas canvas, mxCellState state) {
        double size = 0.4;
        canvas.getGraphics().setPaint(new GradientPaint((float)state.getX(), (float)state.getY(), new Color(1.0f, 1.0f, 1.0f, 0.9f), (float)state.getX(), (float)(state.getY() + state.getHeight() * size), new Color(1.0f, 1.0f, 1.0f, 0.3f)));
        float sw = (float)((double)mxUtils.getFloat(state.getStyle(), mxConstants.STYLE_STROKEWIDTH, 1.0f) * canvas.getScale() / 2.0);
        GeneralPath path = new GeneralPath();
        path.moveTo((float)state.getX() - sw, (float)state.getY() - sw);
        path.lineTo((float)state.getX() - sw, (float)(state.getY() + state.getHeight() * size));
        path.quadTo((float)(state.getX() + state.getWidth() * 0.5), (float)(state.getY() + state.getHeight() * 0.7), (float)(state.getX() + state.getWidth() + (double)sw), (float)(state.getY() + state.getHeight() * size));
        path.lineTo((float)(state.getX() + state.getWidth() + (double)sw), (float)state.getY() - sw);
        path.closePath();
        canvas.getGraphics().fill(path);
    }

    public Rectangle getImageBounds(mxGraphics2DCanvas canvas, mxCellState state) {
        Map<String, Object> style = state.getStyle();
        double scale = canvas.getScale();
        String imgAlign = mxUtils.getString(style, mxConstants.STYLE_IMAGE_ALIGN, "left");
        String imgValign = mxUtils.getString(style, mxConstants.STYLE_IMAGE_VERTICAL_ALIGN, "middle");
        int imgWidth = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_IMAGE_WIDTH, mxConstants.DEFAULT_IMAGESIZE) * scale);
        int imgHeight = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_IMAGE_HEIGHT, mxConstants.DEFAULT_IMAGESIZE) * scale);
        int spacing = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_SPACING, 2) * scale);
        mxRectangle imageBounds = new mxRectangle(state);
        if (imgAlign.equals("center")) {
            imageBounds.setX(imageBounds.getX() + (imageBounds.getWidth() - (double)imgWidth) / 2.0);
        } else if (imgAlign.equals("right")) {
            imageBounds.setX(imageBounds.getX() + imageBounds.getWidth() - (double)imgWidth - (double)spacing - 2.0);
        } else {
            imageBounds.setX(imageBounds.getX() + (double)spacing + 4.0);
        }
        if (imgValign.equals("top")) {
            imageBounds.setY(imageBounds.getY() + (double)spacing);
        } else if (imgValign.equals("bottom")) {
            imageBounds.setY(imageBounds.getY() + imageBounds.getHeight() - (double)imgHeight - (double)spacing);
        } else {
            imageBounds.setY(imageBounds.getY() + (imageBounds.getHeight() - (double)imgHeight) / 2.0);
        }
        imageBounds.setWidth(imgWidth);
        imageBounds.setHeight(imgHeight);
        return imageBounds.getRectangle();
    }

    public Color getFillColor(mxGraphics2DCanvas canvas, mxCellState state) {
        return mxUtils.getColor(state.getStyle(), mxConstants.STYLE_FILLCOLOR);
    }

    public Color getStrokeColor(mxGraphics2DCanvas canvas, mxCellState state) {
        return mxUtils.getColor(state.getStyle(), mxConstants.STYLE_STROKECOLOR);
    }

    public boolean hasGradient(mxGraphics2DCanvas canvas, mxCellState state) {
        return true;
    }
}

