/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.diagnostics.jmx;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.ThreadMXBean;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.neo4j.internal.utils.DumpUtils;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSource;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSources;

public class JmxDump {
    private final MBeanServerConnection mBeanServer;
    private Properties systemProperties;

    private JmxDump(MBeanServerConnection mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public static JmxDump connectTo(String jmxAddress) throws IOException {
        JMXServiceURL url = new JMXServiceURL(jmxAddress);
        JMXConnector connect = JMXConnectorFactory.connect(url);
        return new JmxDump(connect.getMBeanServerConnection());
    }

    public void attachSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public DiagnosticsReportSource threadDump() {
        return DiagnosticsReportSources.newDiagnosticsString((String)"threaddump.txt", () -> {
            String result;
            try {
                result = (String)this.mBeanServer.invoke(new ObjectName("com.sun.management:type=DiagnosticCommand"), "threadPrint", new Object[]{null}, new String[]{String[].class.getName()});
            }
            catch (IOException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException exception) {
                result = this.getMXThreadDump();
            }
            return result;
        });
    }

    private String getMXThreadDump() {
        ThreadMXBean threadMxBean;
        try {
            threadMxBean = ManagementFactory.getPlatformMXBean(this.mBeanServer, ThreadMXBean.class);
        }
        catch (IOException e) {
            return "ERROR: Unable to produce any thread dump";
        }
        return DumpUtils.threadDump((ThreadMXBean)threadMxBean, (Properties)this.systemProperties);
    }

    public DiagnosticsReportSource heapDump() {
        return new DiagnosticsReportSource(){

            public String destinationPath() {
                return "heapdump.hprof";
            }

            public InputStream newInputStream() throws IOException {
                final Path heapdumpFile = Files.createTempFile("neo4j-heapdump", ".hprof", new FileAttribute[0]).toAbsolutePath();
                JmxDump.this.heapDump(heapdumpFile.toString());
                return new FileInputStream(heapdumpFile.toFile()){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        Files.deleteIfExists(heapdumpFile);
                    }
                };
            }

            public long estimatedSize() {
                try {
                    MemoryMXBean bean = ManagementFactory.getPlatformMXBean(JmxDump.this.mBeanServer, MemoryMXBean.class);
                    long totalMemory = bean.getHeapMemoryUsage().getCommitted() + bean.getNonHeapMemoryUsage().getCommitted();
                    return (long)((double)totalMemory * 1.2);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }

    private void heapDump(String destination) throws IOException {
        HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean = ManagementFactory.getPlatformMXBean(this.mBeanServer, HotSpotDiagnosticMXBean.class);
        hotSpotDiagnosticMXBean.dumpHeap(destination, false);
    }

    public DiagnosticsReportSource systemProperties() {
        return new DiagnosticsReportSource(){

            public String destinationPath() {
                return "vm.prop";
            }

            public InputStream newInputStream() {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                JmxDump.this.systemProperties.list(new PrintStream(out, true));
                return new ByteArrayInputStream(out.toByteArray());
            }

            public long estimatedSize() {
                return 0L;
            }
        };
    }
}

