/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.token.api;

import java.util.Objects;

public final class NamedToken {
    private final int id;
    private final String name;
    private final boolean internal;

    public NamedToken(String name, int id) {
        this(name, id, false);
    }

    public NamedToken(String name, int id, boolean internal) {
        this.id = id;
        this.name = name;
        this.internal = internal;
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedToken that = (NamedToken)o;
        return this.id == that.id && this.internal == that.internal && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.internal);
    }

    public String toString() {
        return String.format("%s[name:%s, id:%d, internal:%s]", this.getClass().getSimpleName(), this.name, this.id, this.internal);
    }

    public boolean isInternal() {
        return this.internal;
    }
}

