/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.cypher.internal.CreateIndexWithProviderDescriptorOptions;
import org.neo4j.cypher.internal.IndexOptionsConverter;
import org.neo4j.cypher.internal.OptionsConverter;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.evaluator.ExpressionEvaluator;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.utils.PrettyPrinter;
import org.neo4j.values.virtual.MapValue;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class CreateFulltextIndexOptionsConverter$
implements IndexOptionsConverter<CreateIndexWithProviderDescriptorOptions>,
Product,
scala.Serializable {
    public static CreateFulltextIndexOptionsConverter$ MODULE$;
    private final String schemaType;
    private final ExpressionEvaluator evaluator;

    static {
        new CreateFulltextIndexOptionsConverter$();
    }

    @Override
    public Tuple2<Option<AnyValue>, IndexConfig> getOptionsParts(MapValue options, String schemaType) {
        return IndexOptionsConverter.getOptionsParts$(this, options, schemaType);
    }

    @Override
    public void checkForBtreeProvider(String indexProviderString, String schemaType) {
        IndexOptionsConverter.checkForBtreeProvider$(this, indexProviderString, schemaType);
    }

    @Override
    public void checkForRangeProvider(String indexProviderString, String schemaType) {
        IndexOptionsConverter.checkForRangeProvider$(this, indexProviderString, schemaType);
    }

    @Override
    public void checkForFulltextProvider(String indexProviderString, String schemaType) {
        IndexOptionsConverter.checkForFulltextProvider$(this, indexProviderString, schemaType);
    }

    @Override
    public void checkForTokenLookupProvider(String indexProviderString, String schemaType) {
        IndexOptionsConverter.checkForTokenLookupProvider$(this, indexProviderString, schemaType);
    }

    @Override
    public void checkForTextProvider(String indexProviderString, String schemaType) {
        IndexOptionsConverter.checkForTextProvider$(this, indexProviderString, schemaType);
    }

    @Override
    public void checkForPointProvider(String indexProviderString, String schemaType) {
        IndexOptionsConverter.checkForPointProvider$(this, indexProviderString, schemaType);
    }

    @Override
    public void checkForPointConfigValues(PrettyPrinter pp, MapValue itemsMap, String schemaType) {
        IndexOptionsConverter.checkForPointConfigValues$(this, pp, itemsMap, schemaType);
    }

    @Override
    public void checkForFulltextConfigValues(PrettyPrinter pp, MapValue itemsMap, String schemaType) {
        IndexOptionsConverter.checkForFulltextConfigValues$(this, pp, itemsMap, schemaType);
    }

    @Override
    public Map<String, Object> assertEmptyConfig(AnyValue config, String schemaType, String indexType) {
        return IndexOptionsConverter.assertEmptyConfig$(this, config, schemaType, indexType);
    }

    @Override
    public Map<String, Object> assertValidAndTransformConfigForPointSettings(AnyValue config, String schemaType) {
        return IndexOptionsConverter.assertValidAndTransformConfigForPointSettings$(this, config, schemaType);
    }

    @Override
    public AnyValue evaluate(Expression expression, MapValue params) {
        return OptionsConverter.evaluate$(this, expression, params);
    }

    @Override
    public Option<CreateIndexWithProviderDescriptorOptions> convert(Options options, MapValue params) {
        return OptionsConverter.convert$(this, options, params);
    }

    @Override
    public ExpressionEvaluator evaluator() {
        return this.evaluator;
    }

    @Override
    public void org$neo4j$cypher$internal$OptionsConverter$_setter_$evaluator_$eq(ExpressionEvaluator x$1) {
        this.evaluator = x$1;
    }

    private String schemaType() {
        return this.schemaType;
    }

    @Override
    public CreateIndexWithProviderDescriptorOptions convert(MapValue options) {
        Tuple2<Option<AnyValue>, IndexConfig> tuple2 = this.getOptionsParts(options, this.schemaType());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option maybeIndexProvider = (Option)tuple2._1();
        IndexConfig indexConfig = (IndexConfig)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)maybeIndexProvider, (Object)indexConfig);
        Tuple2 tuple23 = tuple22;
        Option maybeIndexProvider2 = (Option)tuple23._1();
        IndexConfig indexConfig2 = (IndexConfig)tuple23._2();
        Option indexProvider2 = maybeIndexProvider2.map((Function1 & Serializable & scala.Serializable)indexProvider -> MODULE$.assertValidIndexProvider((AnyValue)indexProvider));
        return new CreateIndexWithProviderDescriptorOptions((Option<IndexProviderDescriptor>)indexProvider2, indexConfig2);
    }

    private IndexProviderDescriptor assertValidIndexProvider(AnyValue indexProvider) {
        AnyValue anyValue = indexProvider;
        if (anyValue instanceof TextValue) {
            TextValue textValue = (TextValue)anyValue;
            String indexProviderString = textValue.stringValue();
            this.checkForBtreeProvider(indexProviderString, this.schemaType());
            this.checkForRangeProvider(indexProviderString, this.schemaType());
            this.checkForTokenLookupProvider(indexProviderString, this.schemaType());
            this.checkForTextProvider(indexProviderString, this.schemaType());
            this.checkForPointProvider(indexProviderString, this.schemaType());
            if (!indexProviderString.equalsIgnoreCase(FulltextIndexProviderFactory.DESCRIPTOR.name())) {
                throw new InvalidArgumentsException(new StringBuilder(51).append("Could not create ").append(this.schemaType()).append(" with specified index provider '").append(indexProviderString).append("'.").toString());
            }
        } else {
            throw new InvalidArgumentsException(new StringBuilder(74).append("Could not create ").append(this.schemaType()).append(" with specified index provider '").append(indexProvider).append("'. Expected String value.").toString());
        }
        IndexProviderDescriptor indexProviderDescriptor = FulltextIndexProviderFactory.DESCRIPTOR;
        return indexProviderDescriptor;
    }

    @Override
    public Map<String, Object> assertValidAndTransformConfig(AnyValue config, String schemaType) {
        AnyValue anyValue = config;
        if (!(anyValue instanceof MapValue)) {
            throw CreateFulltextIndexOptionsConverter$.exceptionWrongType$2(anyValue, schemaType);
        }
        MapValue mapValue = (MapValue)anyValue;
        this.checkForPointConfigValues(new PrettyPrinter(), mapValue, schemaType);
        HashMap<String, Object> hm = new HashMap<String, Object>();
        mapValue.foreach((x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                String p = (String)tuple2._1();
                AnyValue e = (AnyValue)tuple2._2();
                if (p != null) {
                    String string = p;
                    if (e instanceof TextValue) {
                        TextValue textValue = (TextValue)e;
                        hm.put(string, textValue.stringValue());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
            }
            if (tuple2 == null) throw CreateFulltextIndexOptionsConverter$.exceptionWrongType$2((AnyValue)mapValue, schemaType);
            String p = (String)tuple2._1();
            AnyValue e = (AnyValue)tuple2._2();
            if (p == null) throw CreateFulltextIndexOptionsConverter$.exceptionWrongType$2((AnyValue)mapValue, schemaType);
            String string = p;
            if (!(e instanceof BooleanValue)) throw CreateFulltextIndexOptionsConverter$.exceptionWrongType$2((AnyValue)mapValue, schemaType);
            BooleanValue booleanValue = (BooleanValue)e;
            hm.put(string, booleanValue.booleanValue());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        HashMap<String, Object> hashMap = hm;
        return hashMap;
    }

    @Override
    public String operation() {
        return new StringBuilder(7).append("create ").append(this.schemaType()).toString();
    }

    public String productPrefix() {
        return "CreateFulltextIndexOptionsConverter";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateFulltextIndexOptionsConverter$;
    }

    public int hashCode() {
        return -612267268;
    }

    public String toString() {
        return "CreateFulltextIndexOptionsConverter";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final InvalidArgumentsException exceptionWrongType$2(AnyValue suppliedValue, String schemaType$3) {
        PrettyPrinter pp = new PrettyPrinter();
        suppliedValue.writeTo((AnyValueWriter)pp);
        return new InvalidArgumentsException(new StringBuilder(101).append("Could not create ").append(schemaType$3).append(" with specified index config '").append(pp.value()).append("'. Expected a map from String to Strings and Booleans.").toString());
    }

    private CreateFulltextIndexOptionsConverter$() {
        MODULE$ = this;
        OptionsConverter.$init$(this);
        IndexOptionsConverter.$init$(this);
        Product.$init$((Product)this);
        this.schemaType = "fulltext index";
    }
}

