/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging.decoder;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.impl.util.BaseToObjectValueWriter;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.UTF8StringValue;
import org.neo4j.values.storable.Values;

public class PrimitiveOnlyValueWriter
extends BaseToObjectValueWriter<RuntimeException> {
    public Object valueAsObject(AnyValue value) {
        value.writeTo((AnyValueWriter)this);
        return this.value();
    }

    Object sensitiveValueAsObject(AnyValue value) {
        if (value instanceof UTF8StringValue) {
            return ((UTF8StringValue)value).bytes();
        }
        if (value == Values.NO_VALUE) {
            return null;
        }
        if (value instanceof StringValue && ((StringValue)value).equals("")) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        return this.valueAsObject(value);
    }

    protected Node newNodeEntityById(long id) {
        throw new UnsupportedOperationException("INIT message metadata should not contain nodes");
    }

    protected Relationship newRelationshipEntityById(long id) {
        throw new UnsupportedOperationException("INIT message metadata should not contain relationships");
    }

    protected Point newPoint(CoordinateReferenceSystem crs, double[] coordinate) {
        throw new UnsupportedOperationException("INIT message metadata should not contain points");
    }

    public void writeByteArray(byte[] value) {
        throw new UnsupportedOperationException("INIT message metadata should not contain byte arrays");
    }

    public void writeDuration(long months, long days, long seconds, int nanos) {
        throw new UnsupportedOperationException("INIT message metadata should not contain durations");
    }

    public void writeDate(LocalDate localDate) {
        throw new UnsupportedOperationException("INIT message metadata should not contain dates");
    }

    public void writeLocalTime(LocalTime localTime) {
        throw new UnsupportedOperationException("INIT message metadata should not contain local dates");
    }

    public void writeTime(OffsetTime offsetTime) {
        throw new UnsupportedOperationException("INIT message metadata should not contain time values");
    }

    public void writeLocalDateTime(LocalDateTime localDateTime) {
        throw new UnsupportedOperationException("INIT message metadata should not contain local date-time values");
    }

    public void writeDateTime(ZonedDateTime zonedDateTime) {
        throw new UnsupportedOperationException("INIT message metadata should not contain date-time values");
    }
}

