/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime.bookmarking;

import java.util.List;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.bolt.runtime.BookmarksParser;
import org.neo4j.bolt.v3.runtime.bookmarking.BookmarkFormatException;
import org.neo4j.bolt.v3.runtime.bookmarking.BookmarkWithPrefix;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;

public final class BookmarksParserV3
implements BookmarksParser {
    public static final BookmarksParserV3 INSTANCE = new BookmarksParserV3();
    private static final String BOOKMARKS_KEY = "bookmarks";
    private static final Long ABSENT_BOOKMARK_ID = -1L;

    private BookmarksParserV3() {
    }

    @Override
    public List<Bookmark> parseBookmarks(AnyValue anyValue) throws BoltIOException {
        return this.parseBookmarks(anyValue);
    }

    @Override
    public List<Bookmark> parseBookmarks(MapValue metadata) throws BookmarkFormatException {
        BookmarkWithPrefix bookmark = BookmarksParserV3.parseMultipleBookmarks(metadata);
        if (bookmark == null) {
            bookmark = BookmarksParserV3.parseSingleBookmark(metadata);
        }
        return bookmark == null ? List.of() : List.of(bookmark);
    }

    private static BookmarkWithPrefix parseMultipleBookmarks(MapValue params) throws BookmarkFormatException {
        AnyValue bookmarksObject = params.get(BOOKMARKS_KEY);
        if (bookmarksObject == Values.NO_VALUE) {
            return null;
        }
        if (bookmarksObject instanceof ListValue) {
            ListValue bookmarks = (ListValue)bookmarksObject;
            long maxTxId = ABSENT_BOOKMARK_ID;
            for (AnyValue bookmark : bookmarks) {
                long txId;
                if (bookmark == Values.NO_VALUE || (txId = BookmarksParserV3.txIdFrom(bookmark)) <= maxTxId) continue;
                maxTxId = txId;
            }
            return maxTxId == ABSENT_BOOKMARK_ID ? null : new BookmarkWithPrefix(maxTxId);
        }
        throw new BookmarkFormatException(bookmarksObject);
    }

    private static BookmarkWithPrefix parseSingleBookmark(MapValue params) throws BookmarkFormatException {
        AnyValue bookmarkObject = params.get("bookmark");
        if (bookmarkObject == Values.NO_VALUE) {
            return null;
        }
        return new BookmarkWithPrefix(BookmarksParserV3.txIdFrom(bookmarkObject));
    }

    private static long txIdFrom(AnyValue bookmark) throws BookmarkFormatException {
        if (!(bookmark instanceof TextValue)) {
            throw new BookmarkFormatException(bookmark);
        }
        String bookmarkString = ((TextValue)bookmark).stringValue();
        if (!bookmarkString.startsWith("neo4j:bookmark:v1:tx")) {
            throw new BookmarkFormatException((Object)bookmarkString);
        }
        try {
            return Long.parseLong(bookmarkString.substring("neo4j:bookmark:v1:tx".length()));
        }
        catch (NumberFormatException e) {
            throw new BookmarkFormatException(bookmarkString, e);
        }
    }
}

