/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.ResultConsumer;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.v3.runtime.FailSafeBoltStateMachineState;
import org.neo4j.bolt.v4.messaging.DiscardMessage;
import org.neo4j.bolt.v4.messaging.DiscardResultConsumer;
import org.neo4j.bolt.v4.messaging.PullMessage;
import org.neo4j.bolt.v4.messaging.PullResultConsumer;
import org.neo4j.util.Preconditions;

public abstract class AbstractStreamingState
extends FailSafeBoltStateMachineState {
    protected BoltStateMachineState readyState;

    @Override
    protected BoltStateMachineState processUnsafe(RequestMessage message, StateMachineContext context) throws Throwable {
        context.connectionState().ensureNoPendingTerminationNotice();
        if (message instanceof PullMessage) {
            PullMessage pullMessage = (PullMessage)message;
            return this.processStreamPullResultMessage(pullMessage.statementId(), new PullResultConsumer(context, pullMessage.n()), context, pullMessage.n());
        }
        if (message instanceof DiscardMessage) {
            DiscardMessage discardMessage = (DiscardMessage)message;
            return this.processStreamDiscardResultMessage(discardMessage.statementId(), new DiscardResultConsumer(context, discardMessage.n()), context, discardMessage.n());
        }
        return null;
    }

    public void setReadyState(BoltStateMachineState readyState) {
        this.readyState = readyState;
    }

    protected abstract BoltStateMachineState processStreamPullResultMessage(int var1, ResultConsumer var2, StateMachineContext var3, long var4) throws Throwable;

    protected abstract BoltStateMachineState processStreamDiscardResultMessage(int var1, ResultConsumer var2, StateMachineContext var3, long var4) throws Throwable;

    @Override
    protected void assertInitialized() {
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
        super.assertInitialized();
    }
}

