/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import org.neo4j.bolt.messaging.ResultConsumer;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.v4.runtime.AbstractStreamingState;
import org.neo4j.memory.HeapEstimator;

public class AutoCommitState
extends AbstractStreamingState {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(AutoCommitState.class);

    @Override
    public String name() {
        return "AUTOCOMMIT";
    }

    @Override
    protected BoltStateMachineState processStreamPullResultMessage(int statementId, ResultConsumer resultConsumer, StateMachineContext context, long noToPull) throws Throwable {
        Bookmark bookmark = context.getTransactionManager().pullData(context.connectionState().getCurrentTransactionId(), statementId, noToPull, resultConsumer);
        bookmark.attachTo(context.connectionState());
        if (resultConsumer.hasMore()) {
            return this;
        }
        return this.readyState;
    }

    @Override
    protected BoltStateMachineState processStreamDiscardResultMessage(int statementId, ResultConsumer resultConsumer, StateMachineContext context, long noToDiscard) throws Throwable {
        Bookmark bookmark = context.getTransactionManager().discardData(context.connectionState().getCurrentTransactionId(), statementId, noToDiscard, resultConsumer);
        bookmark.attachTo(context.connectionState());
        if (resultConsumer.hasMore()) {
            return this;
        }
        return this.readyState;
    }
}

