/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.concurrent.TimeUnit;
import org.neo4j.internal.batchimport.stats.DetailLevel;
import org.neo4j.internal.batchimport.stats.Stat;
import org.neo4j.io.ByteUnit;

public class IoThroughputStat
implements Stat {
    private final long startTime;
    private final long endTime;
    private final long position;

    public IoThroughputStat(long startTime, long endTime, long position) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.position = position;
    }

    @Override
    public DetailLevel detailLevel() {
        return DetailLevel.IMPORTANT;
    }

    @Override
    public long asLong() {
        long endTime = this.endTime != 0L ? this.endTime : System.nanoTime();
        long totalTime = endTime - this.startTime;
        int seconds = (int)TimeUnit.NANOSECONDS.toSeconds(totalTime);
        return seconds > 0 ? this.position / (long)seconds : -1L;
    }

    public String toString() {
        long stat = this.asLong();
        return stat == -1L ? "??" : ByteUnit.bytesToString((long)stat) + "/s";
    }
}

