/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.neo4j.internal.batchimport.cache.DynamicNumberArray;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.memory.MemoryTracker;

public class DynamicLongArray
extends DynamicNumberArray<LongArray>
implements LongArray {
    private final long defaultValue;
    private final MemoryTracker memoryTracker;

    public DynamicLongArray(NumberArrayFactory factory, long chunkSize, long defaultValue, MemoryTracker memoryTracker) {
        super(factory, chunkSize, (NumberArray[])new LongArray[0]);
        this.defaultValue = defaultValue;
        this.memoryTracker = memoryTracker;
    }

    @Override
    public long get(long index) {
        LongArray chunk = (LongArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.get(index) : this.defaultValue;
    }

    @Override
    public void set(long index, long value) {
        ((LongArray)this.at(index)).set(index, value);
    }

    @Override
    protected LongArray addChunk(long chunkSize, long base) {
        return this.factory.newLongArray(chunkSize, this.defaultValue, base, this.memoryTracker);
    }
}

