/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.csv.reader.Chunker;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.csv.CsvInputChunk;

public class CsvInputChunkProxy
implements CsvInputChunk {
    private CsvInputChunk actual;
    private int groupId = -1;

    public void ensureInstantiated(Supplier<CsvInputChunk> newChunk, int groupId) throws IOException {
        if (this.actual == null || groupId != this.groupId) {
            this.closeCurrent();
            this.actual = newChunk.get();
        }
        this.groupId = groupId;
    }

    public void close() throws IOException {
        this.closeCurrent();
    }

    private void closeCurrent() throws IOException {
        if (this.actual != null) {
            this.actual.close();
        }
    }

    @Override
    public boolean fillFrom(Chunker chunker) throws IOException {
        return this.actual.fillFrom(chunker);
    }

    public boolean next(InputEntityVisitor visitor) throws IOException {
        return this.actual.next(visitor);
    }
}

