/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.neo4j.function.Predicates;

public final class Exceptions {
    public static final Thread.UncaughtExceptionHandler SILENT_UNCAUGHT_EXCEPTION_HANDLER = (t, e) -> {};
    private static final Field THROWABLE_MESSAGE_FIELD;

    private Exceptions() {
        throw new AssertionError((Object)"No instances");
    }

    public static void throwIfUnchecked(Throwable exception) {
        Objects.requireNonNull(exception);
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
    }

    public static <T extends Throwable> void throwIfInstanceOf(Throwable exception, Class<T> clazz) throws T {
        Objects.requireNonNull(exception);
        if (clazz.isInstance(exception)) {
            throw (Throwable)clazz.cast(exception);
        }
    }

    public static Optional<Throwable> findCauseOrSuppressed(Throwable e, Predicate<Throwable> predicate) {
        Optional<Throwable> cause;
        if (e == null) {
            return Optional.empty();
        }
        if (predicate.test(e)) {
            return Optional.of(e);
        }
        if (e.getCause() != null && e.getCause() != e && (cause = Exceptions.findCauseOrSuppressed(e.getCause(), predicate)).isPresent()) {
            return cause;
        }
        if (e.getSuppressed() != null) {
            for (Throwable suppressed : e.getSuppressed()) {
                Optional<Throwable> cause2;
                if (suppressed == e || !(cause2 = Exceptions.findCauseOrSuppressed(suppressed, predicate)).isPresent()) continue;
                return cause2;
            }
        }
        return Optional.empty();
    }

    public static StackTraceElement[] getPartialStackTrace(int from, int to) {
        return StackWalker.getInstance().walk(s -> (StackTraceElement[])s.skip(from).limit(to - from).map(StackWalker.StackFrame::toStackTraceElement).toArray(StackTraceElement[]::new));
    }

    public static String stringify(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String stringify(Thread thread, StackTraceElement[] elements) {
        StringBuilder builder = new StringBuilder().append('\"').append(thread.getName()).append('\"').append(thread.isDaemon() ? " daemon" : "").append(" prio=").append(thread.getPriority()).append(" tid=").append(thread.getId()).append(' ').append(thread.getState().name().toLowerCase()).append('\n');
        builder.append("   ").append(Thread.State.class.getName()).append(": ").append(thread.getState().name().toUpperCase()).append('\n');
        for (StackTraceElement element : elements) {
            builder.append("      at ").append(element.getClassName()).append('.').append(element.getMethodName());
            if (element.isNativeMethod()) {
                builder.append("(Native method)");
            } else if (element.getFileName() == null) {
                builder.append("(Unknown source)");
            } else {
                builder.append('(').append(element.getFileName()).append(':').append(element.getLineNumber()).append(')');
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public static boolean contains(Throwable cause, String containsMessage, Class<?> ... anyOfTheseClasses) {
        Predicate anyOfClasses = Predicates.instanceOfAny(anyOfTheseClasses);
        return Exceptions.contains(cause, item -> item.getMessage() != null && item.getMessage().contains(containsMessage) && anyOfClasses.test(item));
    }

    public static boolean contains(Throwable cause, Predicate<Throwable> toLookFor) {
        while (cause != null) {
            if (toLookFor.test(cause)) {
                return true;
            }
            cause = cause.getCause();
        }
        return false;
    }

    public static <T extends Throwable> T withMessage(T cause, String message) {
        try {
            THROWABLE_MESSAGE_FIELD.set(cause, message);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        return cause;
    }

    public static <T extends Throwable> T chain(T initial, T current) {
        if (initial == null) {
            return current;
        }
        if (current != null && initial != current) {
            initial.addSuppressed(current);
        }
        return initial;
    }

    public static <EXCEPTION extends Throwable> EXCEPTION disguiseException(Class<EXCEPTION> disguise, String message, Throwable disguised) {
        Throwable exception;
        try {
            try {
                exception = (Throwable)disguise.getConstructor(String.class, Throwable.class).newInstance(message, disguised);
            }
            catch (NoSuchMethodException e) {
                exception = (Throwable)disguise.getConstructor(String.class).newInstance(message);
                try {
                    exception.initCause(disguised);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        catch (Exception e) {
            throw new Error(message + ". An exception of type " + disguise.getName() + " was requested to be thrown but that proved impossible", e);
        }
        return (EXCEPTION)exception;
    }

    static {
        try {
            THROWABLE_MESSAGE_FIELD = Throwable.class.getDeclaredField("detailMessage");
            THROWABLE_MESSAGE_FIELD.setAccessible(true);
        }
        catch (Exception e2) {
            throw new LinkageError("Could not get Throwable message field", e2);
        }
    }
}

