/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.LongConsumer;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public class BatchingIdGetter
implements IdSequence {
    private final IdGenerator source;
    private final int batchSize;
    private long currentBatchStartId = -1L;
    private int currentBatchIndex;

    BatchingIdGetter(CommonAbstractStore<? extends AbstractBaseRecord, ?> source) {
        this.source = source.getIdGenerator();
        this.batchSize = source.getRecordsPerPage();
    }

    public long nextId(CursorContext cursorContext) {
        long id = this.nextIdFromCurrentBatch();
        if (id != -1L) {
            return id;
        }
        this.currentBatchStartId = this.source.nextConsecutiveIdRange(this.batchSize, false, cursorContext);
        this.currentBatchIndex = 0;
        return this.nextIdFromCurrentBatch();
    }

    private long nextIdFromCurrentBatch() {
        return this.currentBatchStartId == -1L || this.currentBatchIndex == this.batchSize ? -1L : this.currentBatchStartId + (long)this.currentBatchIndex++;
    }

    void visitUnused(LongConsumer visitor) {
        long id;
        while ((id = this.nextIdFromCurrentBatch()) != -1L) {
            visitor.accept(id);
        }
    }
}

