/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.cache.NodeRelationshipCache;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class CalculateDenseNodesStep
extends ProcessorStep<RelationshipRecord[]> {
    private static final int NUM_LATCHES = 1024;
    private static final int LATCH_STRIPE_MASK = Integer.highestOneBit(1024) - 1;
    private final Lock[] latches = new Lock[1024];
    private final NodeRelationshipCache cache;

    public CalculateDenseNodesStep(StageControl control, Configuration config, NodeRelationshipCache cache, StatsProvider ... statsProviders) {
        super(control, "CALCULATE", config, config.maxNumberOfProcessors(), PageCacheTracer.NULL, statsProviders);
        this.cache = cache;
        for (int i = 0; i < this.latches.length; ++i) {
            this.latches[i] = new ReentrantLock();
        }
    }

    protected void process(RelationshipRecord[] batch, BatchSender sender, CursorContext cursorContext) throws Throwable {
        for (RelationshipRecord record : batch) {
            if (!record.inUse()) continue;
            long startNodeId = record.getFirstNode();
            long endNodeId = record.getSecondNode();
            this.processNodeId(startNodeId);
            if (startNodeId == endNodeId) continue;
            this.processNodeId(endNodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNodeId(long nodeId) {
        int hash = (int)(nodeId & (long)LATCH_STRIPE_MASK);
        Lock latch = this.latches[hash];
        latch.lock();
        try {
            this.cache.incrementCount(nodeId);
        }
        finally {
            latch.unlock();
        }
    }
}

