/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import org.neo4j.internal.counts.GBPTreeRelationshipGroupDegreesStore;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.recordstorage.RecordRelationshipTraversalCursor;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class DegreesRebuildFromStore
implements GBPTreeRelationshipGroupDegreesStore.DegreesRebuilder {
    private final NeoStores neoStores;

    public DegreesRebuildFromStore(NeoStores neoStores) {
        this.neoStores = neoStores;
    }

    @Override
    public long lastCommittedTxId() {
        return this.neoStores.getMetaDataStore().getLastCommittedTransactionId();
    }

    @Override
    public void rebuild(RelationshipGroupDegreesStore.Updater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
        RelationshipGroupStore groupStore = this.neoStores.getRelationshipGroupStore();
        try (CachedStoreCursors storeCursors = new CachedStoreCursors(this.neoStores, cursorContext);
             RecordStorageReader storageReader = new RecordStorageReader(this.neoStores);
             RecordRelationshipTraversalCursor traversalCursor = storageReader.allocateRelationshipTraversalCursor(cursorContext, (StoreCursors)storeCursors);
             PageCursor groupCursor = groupStore.openPageCursorForReadingWithPrefetching(0L, cursorContext);){
            RelationshipGroupRecord groupRecord = (RelationshipGroupRecord)groupStore.newRecord();
            long highGroupId = groupStore.getHighId();
            for (long id = (long)groupStore.getNumberOfReservedLowIds(); id < highGroupId; ++id) {
                groupStore.getRecordByCursor(id, groupRecord, RecordLoad.LENIENT_CHECK, groupCursor);
                if (!groupRecord.inUse() || !groupRecord.hasExternalDegreesOut() && !groupRecord.hasExternalDegreesIn() && !groupRecord.hasExternalDegreesLoop()) continue;
                DegreesRebuildFromStore.updateDegree(groupRecord.hasExternalDegreesOut(), groupRecord.getFirstOut(), groupRecord, RelationshipDirection.OUTGOING, traversalCursor, updater);
                DegreesRebuildFromStore.updateDegree(groupRecord.hasExternalDegreesIn(), groupRecord.getFirstIn(), groupRecord, RelationshipDirection.INCOMING, traversalCursor, updater);
                DegreesRebuildFromStore.updateDegree(groupRecord.hasExternalDegreesLoop(), groupRecord.getFirstLoop(), groupRecord, RelationshipDirection.LOOP, traversalCursor, updater);
            }
        }
    }

    private static void updateDegree(boolean hasExternalDegrees, long firstRel, RelationshipGroupRecord groupRecord, RelationshipDirection direction, StorageRelationshipTraversalCursor traversalCursor, RelationshipGroupDegreesStore.Updater updater) {
        if (!hasExternalDegrees) {
            return;
        }
        traversalCursor.init(groupRecord.getOwningNode(), firstRel, RelationshipSelection.ALL_RELATIONSHIPS);
        long degree = 0L;
        while (traversalCursor.next()) {
            ++degree;
        }
        updater.increment(groupRecord.getId(), direction, degree);
    }
}

