/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.recordstorage.CacheAccessBackDoor;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;

class BridgingCacheAccess
implements CacheAccessBackDoor {
    private final SchemaCache schemaCache;
    private final SchemaState schemaState;
    private final TokenHolders tokenHolders;

    BridgingCacheAccess(SchemaCache schemaCache, SchemaState schemaState, TokenHolders tokenHolders) {
        this.schemaCache = schemaCache;
        this.schemaState = schemaState;
        this.tokenHolders = tokenHolders;
    }

    @Override
    public void addSchemaRule(SchemaRule rule) {
        this.schemaCache.addSchemaRule(rule);
    }

    @Override
    public void removeSchemaRuleFromCache(long id) {
        this.schemaCache.removeSchemaRule(id);
        this.schemaState.clear();
    }

    @Override
    public void addRelationshipTypeToken(NamedToken type) {
        this.tokenHolders.relationshipTypeTokens().addToken(type);
    }

    @Override
    public void addLabelToken(NamedToken label) {
        this.tokenHolders.labelTokens().addToken(label);
    }

    @Override
    public void addPropertyKeyToken(NamedToken propertyKey) {
        this.tokenHolders.propertyKeyTokens().addToken(propertyKey);
    }
}

