/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsStore;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.function.ThrowingAction;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.DegreesRebuildFromStore;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.counts.GBPTreeGenericCountsStore;
import org.neo4j.internal.counts.GBPTreeRelationshipGroupDegreesStore;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.DiagnosticsManager;
import org.neo4j.internal.diagnostics.DiagnosticsProvider;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.SchemaIdType;
import org.neo4j.internal.kernel.api.exceptions.TransactionApplyKernelException;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.BatchContextImpl;
import org.neo4j.internal.recordstorage.BridgingCacheAccess;
import org.neo4j.internal.recordstorage.CacheAccessBackDoor;
import org.neo4j.internal.recordstorage.CacheInvalidationTransactionApplierFactory;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.CommandLockVerification;
import org.neo4j.internal.recordstorage.ConsistencyCheckingApplierFactory;
import org.neo4j.internal.recordstorage.CountsRecordState;
import org.neo4j.internal.recordstorage.CountsStoreTransactionApplierFactory;
import org.neo4j.internal.recordstorage.HighIdTransactionApplierFactory;
import org.neo4j.internal.recordstorage.IndexTransactionApplierFactory;
import org.neo4j.internal.recordstorage.IntegrityValidator;
import org.neo4j.internal.recordstorage.LockVerificationMonitor;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.NeoStoreTransactionApplierFactory;
import org.neo4j.internal.recordstorage.NeoStoresDiagnostics;
import org.neo4j.internal.recordstorage.RecordIdType;
import org.neo4j.internal.recordstorage.RecordStorageCommandCreationContext;
import org.neo4j.internal.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.internal.recordstorage.RecordStorageLocks;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.internal.recordstorage.TransactionApplierFactoryChain;
import org.neo4j.internal.recordstorage.TransactionRecordState;
import org.neo4j.internal.recordstorage.TransactionToRecordStateVisitor;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.api.InjectedNLIUpgradeCallback;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.store.stats.RecordDatabaseEntityCounters;
import org.neo4j.kernel.impl.store.stats.StoreEntityCounters;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.lock.LockGroup;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Health;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.CommandStream;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.CountsDelta;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.KernelVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TransactionCountingStateVisitor;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.storageengine.util.IdGeneratorUpdatesWorkSync;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.storageengine.util.IndexUpdatesWorkSync;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public class RecordStorageEngine
implements StorageEngine,
Lifecycle {
    private static final String STORAGE_ENGINE_START_TAG = "storageEngineStart";
    private static final String SCHEMA_CACHE_START_TAG = "schemaCacheStart";
    private static final String TOKENS_INIT_TAG = "tokensInitialisation";
    private static final String SCHEMA_UPGRADE_TAG = "schemaUpgrade";
    private final NeoStores neoStores;
    private final RecordDatabaseLayout databaseLayout;
    private final Config config;
    private final LogProvider internalLogProvider;
    private final TokenHolders tokenHolders;
    private final Health databaseHealth;
    private final SchemaCache schemaCache;
    private final IntegrityValidator integrityValidator;
    private final CacheAccessBackDoor cacheAccess;
    private final SchemaState schemaState;
    private final SchemaRuleAccess schemaRuleAccess;
    private final ConstraintRuleAccessor constraintSemantics;
    private final LockService lockService;
    private final boolean consistencyCheckApply;
    private IndexUpdatesWorkSync indexUpdatesSync;
    private final IdController idController;
    private final PageCacheTracer cacheTracer;
    private final MemoryTracker otherMemoryTracker;
    private final CommandLockVerification.Factory commandLockVerificationFactory;
    private final LockVerificationMonitor.Factory lockVerificationFactory;
    private final GBPTreeCountsStore countsStore;
    private final RelationshipGroupDegreesStore groupDegreesStore;
    private final int denseNodeThreshold;
    private final IdGeneratorUpdatesWorkSync idGeneratorWorkSyncs = new IdGeneratorUpdatesWorkSync();
    private final Map<TransactionApplicationMode, TransactionApplierFactoryChain> applierChains = new EnumMap<TransactionApplicationMode, TransactionApplierFactoryChain>(TransactionApplicationMode.class);
    private final RecordDatabaseEntityCounters storeEntityCounters;
    private IndexUpdateListener indexUpdateListener;

    public RecordStorageEngine(RecordDatabaseLayout databaseLayout, Config config, PageCache pageCache, FileSystemAbstraction fs, LogProvider internalLogProvider, LogProvider userLogProvider, TokenHolders tokenHolders, SchemaState schemaState, ConstraintRuleAccessor constraintSemantics, IndexConfigCompleter indexConfigCompleter, LockService lockService, Health databaseHealth, IdGeneratorFactory idGeneratorFactory, IdController idController, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, PageCacheTracer cacheTracer, boolean createStoreIfNotExists, MemoryTracker otherMemoryTracker, DatabaseReadOnlyChecker readOnlyChecker, CommandLockVerification.Factory commandLockVerificationFactory, LockVerificationMonitor.Factory lockVerificationFactory) {
        this.databaseLayout = databaseLayout;
        this.config = config;
        this.internalLogProvider = internalLogProvider;
        this.tokenHolders = tokenHolders;
        this.schemaState = schemaState;
        this.lockService = lockService;
        this.databaseHealth = databaseHealth;
        this.constraintSemantics = constraintSemantics;
        this.idController = idController;
        this.cacheTracer = cacheTracer;
        this.otherMemoryTracker = otherMemoryTracker;
        this.commandLockVerificationFactory = commandLockVerificationFactory;
        this.lockVerificationFactory = lockVerificationFactory;
        StoreFactory factory = new StoreFactory((DatabaseLayout)databaseLayout, config, idGeneratorFactory, pageCache, fs, internalLogProvider, cacheTracer, readOnlyChecker);
        this.neoStores = factory.openAllNeoStores(createStoreIfNotExists);
        Stream.of(RecordIdType.values()).forEach(idType -> this.idGeneratorWorkSyncs.add(idGeneratorFactory.get((IdType)idType)));
        Stream.of(SchemaIdType.values()).forEach(idType -> this.idGeneratorWorkSyncs.add(idGeneratorFactory.get((IdType)idType)));
        try {
            this.schemaRuleAccess = SchemaRuleAccess.getSchemaRuleAccess(this.neoStores.getSchemaStore(), tokenHolders, (KernelVersionRepository)this.neoStores.getMetaDataStore());
            this.schemaCache = new SchemaCache(constraintSemantics, indexConfigCompleter);
            this.integrityValidator = new IntegrityValidator(this.neoStores);
            this.cacheAccess = new BridgingCacheAccess(this.schemaCache, schemaState, tokenHolders);
            this.denseNodeThreshold = (Integer)config.get(GraphDatabaseSettings.dense_node_threshold);
            this.countsStore = this.openCountsStore(pageCache, fs, databaseLayout, internalLogProvider, userLogProvider, recoveryCleanupWorkCollector, readOnlyChecker, config, cacheTracer);
            this.groupDegreesStore = this.openDegreesStore(pageCache, fs, databaseLayout, userLogProvider, recoveryCleanupWorkCollector, readOnlyChecker, config, cacheTracer);
            this.consistencyCheckApply = (Boolean)config.get(GraphDatabaseInternalSettings.consistency_check_on_apply);
            this.storeEntityCounters = new RecordDatabaseEntityCounters(idGeneratorFactory, (CountsAccessor)this.countsStore);
        }
        catch (Throwable failure) {
            this.neoStores.close();
            throw failure;
        }
    }

    private void buildApplierChains() {
        for (TransactionApplicationMode mode : TransactionApplicationMode.values()) {
            this.applierChains.put(mode, this.buildApplierFacadeChain(mode));
        }
    }

    private TransactionApplierFactoryChain buildApplierFacadeChain(TransactionApplicationMode mode) {
        Function<IdGeneratorUpdatesWorkSync, IdUpdateListener> idUpdateListenerFunction = mode == TransactionApplicationMode.REVERSE_RECOVERY ? workSync -> IdUpdateListener.IGNORE : workSync -> workSync.newBatch(this.cacheTracer);
        ArrayList<TransactionApplierFactory> appliers = new ArrayList<TransactionApplierFactory>();
        if (this.consistencyCheckApply && mode.needsAuxiliaryStores()) {
            appliers.add(new ConsistencyCheckingApplierFactory(this.neoStores));
        }
        appliers.add(new NeoStoreTransactionApplierFactory(mode, this.neoStores, this.cacheAccess, this.lockService(mode)));
        if (mode.needsHighIdTracking()) {
            appliers.add(new HighIdTransactionApplierFactory(this.neoStores));
        }
        if (mode.needsCacheInvalidationOnUpdates()) {
            appliers.add(new CacheInvalidationTransactionApplierFactory(this.neoStores, this.cacheAccess));
        }
        if (mode.needsAuxiliaryStores()) {
            appliers.add(new CountsStoreTransactionApplierFactory((CountsStore)this.countsStore, this.groupDegreesStore));
            appliers.add(new IndexTransactionApplierFactory(this.indexUpdateListener));
        }
        return new TransactionApplierFactoryChain(idUpdateListenerFunction, appliers.toArray(new TransactionApplierFactory[0]));
    }

    private GBPTreeCountsStore openCountsStore(final PageCache pageCache, FileSystemAbstraction fs, final RecordDatabaseLayout layout, final LogProvider internalLogProvider, LogProvider userLogProvider, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, DatabaseReadOnlyChecker readOnlyChecker, Config config, final PageCacheTracer pageCacheTracer) {
        try {
            return new GBPTreeCountsStore(pageCache, layout.countStore(), fs, recoveryCleanupWorkCollector, new CountsBuilder(){
                private final Log log;
                {
                    this.log = internalLogProvider.getLog(MetaDataStore.class);
                }

                public void initialize(CountsAccessor.Updater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
                    this.log.warn("Missing counts store, rebuilding it.");
                    new CountsComputer(RecordStorageEngine.this.neoStores, pageCache, pageCacheTracer, (DatabaseLayout)layout, memoryTracker, this.log).initialize(updater, cursorContext, memoryTracker);
                    this.log.warn("Counts store rebuild completed.");
                }

                public long lastCommittedTxId() {
                    return RecordStorageEngine.this.neoStores.getMetaDataStore().getLastCommittedTransactionId();
                }
            }, readOnlyChecker, pageCacheTracer, GBPTreeGenericCountsStore.NO_MONITOR, layout.getDatabaseName(), ((Integer)config.get(GraphDatabaseInternalSettings.counts_store_max_cached_entries)).intValue(), userLogProvider);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    private RelationshipGroupDegreesStore openDegreesStore(PageCache pageCache, FileSystemAbstraction fs, RecordDatabaseLayout layout, LogProvider userLogProvider, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, DatabaseReadOnlyChecker readOnlyChecker, Config config, PageCacheTracer pageCacheTracer) {
        try {
            return new GBPTreeRelationshipGroupDegreesStore(pageCache, layout.relationshipGroupDegreesStore(), fs, recoveryCleanupWorkCollector, new DegreesRebuildFromStore(this.neoStores), readOnlyChecker, pageCacheTracer, GBPTreeGenericCountsStore.NO_MONITOR, layout.getDatabaseName(), (Integer)config.get(GraphDatabaseInternalSettings.counts_store_max_cached_entries), userLogProvider);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    public RecordStorageReader newReader() {
        return new RecordStorageReader(this.tokenHolders, this.neoStores, (CountsAccessor)this.countsStore, this.groupDegreesStore, this.schemaCache);
    }

    public RecordStorageCommandCreationContext newCommandCreationContext(MemoryTracker memoryTracker) {
        return new RecordStorageCommandCreationContext(this.neoStores, (TokenNameLookup)this.tokenHolders, this.internalLogProvider, this.denseNodeThreshold, this::relaxedLockingForDenseNodes, this.config, memoryTracker);
    }

    public StoreCursors createStorageCursors(CursorContext cursorContext) {
        return new CachedStoreCursors(this.neoStores, cursorContext);
    }

    public StorageLocks createStorageLocks(ResourceLocker locker) {
        return new RecordStorageLocks(locker);
    }

    public void addIndexUpdateListener(IndexUpdateListener listener) {
        Preconditions.checkState((this.indexUpdateListener == null ? 1 : 0) != 0, (String)("Only supports a single listener. Tried to add " + listener + ", but " + this.indexUpdateListener + " has already been added"));
        this.indexUpdateListener = listener;
        this.indexUpdatesSync = new IndexUpdatesWorkSync(listener);
        this.integrityValidator.setIndexValidator(listener);
    }

    public void createCommands(Collection<StorageCommand> commands, ReadableTransactionState txState, StorageReader storageReader, CommandCreationContext commandCreationContext, ResourceLocker locks, LockTracer lockTracer, long lastTransactionIdWhenStarted, TxStateVisitor.Decorator additionalTxStateVisitor, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker transactionMemoryTracker) throws KernelException {
        if (txState != null) {
            KernelVersion version = this.neoStores.getMetaDataStore().kernelVersion();
            Preconditions.checkState((boolean)version.isAtLeast(KernelVersion.V4_2), (String)"Can not write older version than %s. Requested %s", (Object[])new Object[]{KernelVersion.V4_2, version});
            RecordStorageCommandCreationContext creationContext = (RecordStorageCommandCreationContext)commandCreationContext;
            LogCommandSerialization serialization = RecordStorageCommandReaderFactory.INSTANCE.get(version);
            TransactionRecordState recordState = creationContext.createTransactionRecordState(this.integrityValidator, lastTransactionIdWhenStarted, locks, lockTracer, serialization, this.lockVerificationFactory.create(locks, txState, this.neoStores, this.schemaRuleAccess, storeCursors));
            TransactionToRecordStateVisitor txStateVisitor = new TransactionToRecordStateVisitor(recordState, this.schemaState, this.schemaRuleAccess, this.constraintSemantics, cursorContext, storeCursors);
            CountsRecordState countsRecordState = new CountsRecordState(serialization);
            txStateVisitor = (TxStateVisitor)additionalTxStateVisitor.apply((Object)txStateVisitor);
            try (TransactionToRecordStateVisitor visitor = txStateVisitor = new TransactionCountingStateVisitor((TxStateVisitor)txStateVisitor, storageReader, txState, (CountsDelta)countsRecordState, cursorContext, storeCursors);){
                txState.accept((TxStateVisitor)visitor);
            }
            recordState.extractCommands(commands, transactionMemoryTracker);
            countsRecordState.extractCommands(commands, transactionMemoryTracker);
            CommandLockVerification commandLockVerification = this.commandLockVerificationFactory.create(locks, txState, this.neoStores, this.schemaRuleAccess, storeCursors);
            commandLockVerification.verifySufficientlyLocked(commands);
        }
    }

    public List<StorageCommand> createUpgradeCommands(KernelVersion versionToUpgradeTo, InjectedNLIUpgradeCallback injectedNLIUpgradeCallback) {
        MetaDataStore metaDataStore = this.neoStores.getMetaDataStore();
        KernelVersion currentVersion = metaDataStore.kernelVersion();
        Preconditions.checkState((boolean)currentVersion.isAtLeast(KernelVersion.V4_2), (String)"Upgrade transaction was introduced in %s and must be done from at least %s. Tried upgrading from %s to %s", (Object[])new Object[]{KernelVersion.V4_3_D4, KernelVersion.V4_2, currentVersion, versionToUpgradeTo});
        Preconditions.checkState((boolean)versionToUpgradeTo.isGreaterThan(currentVersion), (String)"Can not downgrade from %s to %s", (Object[])new Object[]{currentVersion, versionToUpgradeTo});
        int id = MetaDataStore.Position.KERNEL_VERSION.id();
        MetaDataRecord before = metaDataStore.newRecord();
        before.setId(id);
        before.initialize(true, currentVersion.version());
        MetaDataRecord after = metaDataStore.newRecord();
        after.setId(id);
        after.initialize(true, versionToUpgradeTo.version());
        LogCommandSerialization serialization = RecordStorageCommandReaderFactory.INSTANCE.get(versionToUpgradeTo);
        ArrayList<StorageCommand> commands = new ArrayList<StorageCommand>();
        commands.add(new Command.MetaDataCommand(serialization, before, after));
        if (currentVersion.isLessThan(KernelVersion.VERSION_IN_WHICH_TOKEN_INDEXES_ARE_INTRODUCED)) {
            commands.add(this.createSchemaUpgradeCommand(serialization, injectedNLIUpgradeCallback));
        }
        return commands;
    }

    private StorageCommand createSchemaUpgradeCommand(LogCommandSerialization serialization, InjectedNLIUpgradeCallback injectedNLIUpgradeCallback) {
        try (CursorContext cursorContext = new CursorContext(this.cacheTracer.createPageCursorTracer(SCHEMA_UPGRADE_TAG));){
            SchemaStore schemaStore = this.neoStores.getSchemaStore();
            long nliId = schemaStore.nextId(cursorContext);
            SchemaRecord before = (SchemaRecord)schemaStore.newRecord();
            before.setId(nliId);
            before.initialize(false, Record.NO_NEXT_PROPERTY.longValue());
            SchemaRecord after = (SchemaRecord)schemaStore.newRecord();
            after.setId(nliId);
            after.initialize(true, Record.NO_NEXT_PROPERTY.longValue());
            after.setCreated();
            IndexDescriptor rule = IndexDescriptor.NLI_PROTOTYPE.materialise(nliId);
            injectedNLIUpgradeCallback.apply(nliId);
            Command.SchemaRuleCommand schemaRuleCommand = new Command.SchemaRuleCommand(serialization, before, after, (SchemaRule)rule);
            return schemaRuleCommand;
        }
    }

    public void lockRecoveryCommands(CommandStream commands, LockService lockService, LockGroup lockGroup, TransactionApplicationMode mode) {
        try {
            commands.accept(element -> {
                ((Command)element).lockForRecovery(lockService, lockGroup, mode);
                return false;
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void apply(CommandsToApply batch, TransactionApplicationMode mode) throws Exception {
        TransactionApplierFactoryChain batchApplier = this.applierChain(mode);
        CommandsToApply initialBatch = batch;
        try (BatchContext context = this.createBatchContext(batchApplier, batch);){
            while (batch != null) {
                try (TransactionApplier txApplier = batchApplier.startTx(batch, context);){
                    batch.accept((Visitor)txApplier);
                }
                batch = batch.next();
            }
        }
        catch (Throwable cause) {
            TransactionApplyKernelException kernelException = new TransactionApplyKernelException(cause, "Failed to apply transaction: %s", new Object[]{batch == null ? initialBatch : batch});
            this.databaseHealth.panic((Throwable)kernelException);
            throw kernelException;
        }
    }

    private BatchContext createBatchContext(TransactionApplierFactoryChain batchApplier, CommandsToApply initialBatch) {
        return new BatchContextImpl(this.indexUpdateListener, this.indexUpdatesSync, this.neoStores.getNodeStore(), this.neoStores.getPropertyStore(), this, this.schemaCache, initialBatch.cursorContext(), this.otherMemoryTracker, batchApplier.getIdUpdateListener(this.idGeneratorWorkSyncs), initialBatch.storeCursors());
    }

    protected TransactionApplierFactoryChain applierChain(TransactionApplicationMode mode) {
        return this.applierChains.get(mode);
    }

    private LockService lockService(TransactionApplicationMode mode) {
        return mode == TransactionApplicationMode.RECOVERY || mode == TransactionApplicationMode.REVERSE_RECOVERY ? LockService.NO_LOCK_SERVICE : this.lockService;
    }

    public void init() {
        this.buildApplierChains();
    }

    public void start() throws Exception {
        try (CursorContext cursorContext = new CursorContext(this.cacheTracer.createPageCursorTracer(STORAGE_ENGINE_START_TAG));
             CachedStoreCursors storeCursors = new CachedStoreCursors(this.neoStores, cursorContext);){
            this.neoStores.start(cursorContext);
            this.countsStore.start(cursorContext, (StoreCursors)storeCursors, this.otherMemoryTracker);
            this.groupDegreesStore.start(cursorContext, (StoreCursors)storeCursors, this.otherMemoryTracker);
            this.idController.start();
        }
    }

    @VisibleForTesting
    public void loadSchemaCache() {
        try (CursorContext cursorContext = new CursorContext(this.cacheTracer.createPageCursorTracer(SCHEMA_CACHE_START_TAG));
             CachedStoreCursors storeCursors = new CachedStoreCursors(this.neoStores, cursorContext);){
            this.schemaCache.load(this.schemaRuleAccess.getAll((StoreCursors)storeCursors));
        }
    }

    public void stop() throws Exception {
        ThrowingAction[] throwingActionArray = new ThrowingAction[1];
        throwingActionArray[0] = () -> ((IdController)this.idController).stop();
        ThrowingAction.executeAll((ThrowingAction[])throwingActionArray);
    }

    public void shutdown() throws Exception {
        ThrowingAction[] throwingActionArray = new ThrowingAction[3];
        throwingActionArray[0] = () -> ((GBPTreeCountsStore)this.countsStore).close();
        throwingActionArray[1] = () -> ((RelationshipGroupDegreesStore)this.groupDegreesStore).close();
        throwingActionArray[2] = this.neoStores::close;
        ThrowingAction.executeAll((ThrowingAction[])throwingActionArray);
    }

    public void flushAndForce(CursorContext cursorContext) throws IOException {
        this.countsStore.checkpoint(cursorContext);
        this.groupDegreesStore.checkpoint(cursorContext);
        this.neoStores.flush(cursorContext);
    }

    public void dumpDiagnostics(Log errorLog, DiagnosticsLogger diagnosticsLog) {
        DiagnosticsManager.dump((DiagnosticsProvider)new NeoStoresDiagnostics.NeoStoreIdUsage(this.neoStores), (Log)errorLog, (DiagnosticsLogger)diagnosticsLog);
        DiagnosticsManager.dump((DiagnosticsProvider)new NeoStoresDiagnostics.NeoStoreRecords(this.neoStores), (Log)errorLog, (DiagnosticsLogger)diagnosticsLog);
        DiagnosticsManager.dump((DiagnosticsProvider)new NeoStoresDiagnostics.NeoStoreVersions(this.neoStores), (Log)errorLog, (DiagnosticsLogger)diagnosticsLog);
    }

    public void forceClose() {
        try {
            this.shutdown();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void listStorageFiles(Collection<StoreFileMetadata> atomic, Collection<StoreFileMetadata> replayable) {
        atomic.add(new StoreFileMetadata(this.databaseLayout.countStore(), 1));
        atomic.add(new StoreFileMetadata(this.databaseLayout.relationshipGroupDegreesStore(), 1));
        for (StoreType type : StoreType.values()) {
            RecordStore recordStore = this.neoStores.getRecordStore(type);
            StoreFileMetadata metadata = new StoreFileMetadata(recordStore.getStorageFile(), recordStore.getRecordSize());
            replayable.add(metadata);
        }
    }

    private boolean relaxedLockingForDenseNodes() {
        return this.neoStores.getMetaDataStore().kernelVersion().isAtLeast(KernelVersion.V4_3_D4);
    }

    @VisibleForTesting
    public NeoStores testAccessNeoStores() {
        return this.neoStores;
    }

    @VisibleForTesting
    public SchemaRuleAccess testAccessSchemaRules() {
        return this.schemaRuleAccess;
    }

    public StoreId getStoreId() {
        return this.neoStores.getMetaDataStore().getStoreId();
    }

    public Lifecycle schemaAndTokensLifecycle() {
        return new LifecycleAdapter(){

            public void init() {
                try (CursorContext cursorContext = new CursorContext(RecordStorageEngine.this.cacheTracer.createPageCursorTracer(RecordStorageEngine.TOKENS_INIT_TAG));
                     CachedStoreCursors storeCursors = new CachedStoreCursors(RecordStorageEngine.this.neoStores, cursorContext);){
                    RecordStorageEngine.this.tokenHolders.setInitialTokens(StoreTokens.allTokens(RecordStorageEngine.this.neoStores), (StoreCursors)storeCursors);
                }
                RecordStorageEngine.this.loadSchemaCache();
            }
        };
    }

    public CountsAccessor countsAccessor() {
        return this.countsStore;
    }

    @VisibleForTesting
    public RelationshipGroupDegreesStore relationshipGroupDegreesStore() {
        return this.groupDegreesStore;
    }

    public MetadataProvider metadataProvider() {
        return this.neoStores.getMetaDataStore();
    }

    public StoreEntityCounters storeEntityCounters() {
        return this.storeEntityCounters;
    }
}

