/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class NodeLabelsField {
    private NodeLabelsField() {
    }

    public static NodeLabels parseLabelsField(NodeRecord node) {
        long labelField = node.getLabelField();
        return NodeLabelsField.fieldPointsToDynamicRecordOfLabels(labelField) ? new DynamicNodeLabels(node) : new InlineNodeLabels(node);
    }

    public static long[] get(NodeRecord node, NodeStore nodeStore, StoreCursors storeCursors) {
        return NodeLabelsField.fieldPointsToDynamicRecordOfLabels(node.getLabelField()) ? DynamicNodeLabels.get(node, nodeStore, storeCursors) : InlineNodeLabels.get(node);
    }

    public static boolean hasLabel(NodeRecord node, NodeStore nodeStore, StoreCursors storeCursors, int label) {
        return NodeLabelsField.fieldPointsToDynamicRecordOfLabels(node.getLabelField()) ? DynamicNodeLabels.hasLabel(node, nodeStore, storeCursors, label) : InlineNodeLabels.hasLabel(node, label);
    }

    public static boolean fieldPointsToDynamicRecordOfLabels(long labelField) {
        return (labelField & 0x8000000000L) != 0L;
    }

    public static long parseLabelsBody(long labelField) {
        return labelField & 0xFFFFFFFFFL;
    }

    public static long firstDynamicLabelRecordId(long labelField) {
        assert (NodeLabelsField.fieldPointsToDynamicRecordOfLabels(labelField));
        return NodeLabelsField.parseLabelsBody(labelField);
    }
}

