/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.Objects;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;

public abstract class PrimitiveRecord
extends AbstractBaseRecord {
    protected long nextProp;

    PrimitiveRecord(long id) {
        super(id);
    }

    public PrimitiveRecord(PrimitiveRecord other) {
        super(other);
        this.nextProp = other.nextProp;
    }

    @Override
    public void clear() {
        super.clear();
        this.nextProp = Record.NO_NEXT_PROPERTY.intValue();
    }

    protected PrimitiveRecord initialize(boolean inUse, long nextProp) {
        super.initialize(inUse);
        this.nextProp = nextProp;
        return this;
    }

    public long getNextProp() {
        return this.nextProp;
    }

    public void setNextProp(long nextProp) {
        this.nextProp = nextProp;
    }

    public abstract void setIdTo(PropertyRecord var1);

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nextProp);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        PrimitiveRecord other = (PrimitiveRecord)obj;
        return this.nextProp == other.nextProp;
    }
}

