/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.stats;

import org.neo4j.counts.CountsAccessor;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.SchemaIdType;
import org.neo4j.internal.recordstorage.RecordIdType;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.stats.StoreEntityCounters;

public class RecordDatabaseEntityCounters
implements StoreEntityCounters {
    private final IdGeneratorFactory idGeneratorFactory;
    private final CountsAccessor countsAccessor;

    public RecordDatabaseEntityCounters(IdGeneratorFactory idGeneratorFactory, CountsAccessor countsAccessor) {
        this.idGeneratorFactory = idGeneratorFactory;
        this.countsAccessor = countsAccessor;
    }

    public long nodes() {
        return this.idGeneratorFactory.get((IdType)RecordIdType.NODE).getNumberOfIdsInUse();
    }

    public long relationships() {
        return this.idGeneratorFactory.get((IdType)RecordIdType.RELATIONSHIP).getNumberOfIdsInUse();
    }

    public long properties() {
        return this.idGeneratorFactory.get((IdType)RecordIdType.PROPERTY).getNumberOfIdsInUse();
    }

    public long relationshipTypes() {
        return this.idGeneratorFactory.get((IdType)SchemaIdType.RELATIONSHIP_TYPE_TOKEN).getNumberOfIdsInUse();
    }

    public long allNodesCountStore(CursorContext cursorContext) {
        return this.countsAccessor.nodeCount(-1, cursorContext);
    }

    public long allRelationshipsCountStore(CursorContext cursorContext) {
        return this.countsAccessor.relationshipCount(-1, -1, -1, cursorContext);
    }
}

