/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.internal.collector.RetrieveResult;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;

final class TokensSection {
    private TokensSection() {
    }

    static Stream<RetrieveResult> retrieve(Kernel kernel) throws TransactionFailureException {
        try (KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            TokenRead tokens = tx.tokenRead();
            ArrayList labels = new ArrayList(tokens.labelCount());
            tokens.labelsGetAllTokens().forEachRemaining(t -> labels.add(t.name()));
            ArrayList relationshipTypes = new ArrayList(tokens.relationshipTypeCount());
            tokens.relationshipTypesGetAllTokens().forEachRemaining(t -> relationshipTypes.add(t.name()));
            ArrayList propertyKeys = new ArrayList(tokens.propertyKeyCount());
            tokens.propertyKeyGetAllTokens().forEachRemaining(t -> propertyKeys.add(t.name()));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("labels", labels);
            data.put("relationshipTypes", relationshipTypes);
            data.put("propertyKeys", propertyKeys);
            Stream<RetrieveResult> stream = Stream.of(new RetrieveResult("TOKENS", data));
            return stream;
        }
    }

    static void putTokenCounts(Map<String, Object> metaData, Kernel kernel) throws TransactionFailureException {
        try (KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            TokenRead tokens = tx.tokenRead();
            metaData.put("labelCount", tokens.labelCount());
            metaData.put("relationshipTypeCount", tokens.relationshipTypeCount());
            metaData.put("propertyKeyCount", tokens.propertyKeyCount());
            tx.commit();
        }
    }
}

