/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.frontend;

import com.alibaba.graphscope.GraphServer;
import com.alibaba.graphscope.common.client.channel.ChannelFetcher;
import com.alibaba.graphscope.common.client.channel.HostsRpcChannelFetcher;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.ir.meta.IrMetaTracker;
import com.alibaba.graphscope.common.ir.meta.fetcher.IrMetaFetcher;
import com.alibaba.graphscope.common.ir.meta.fetcher.StaticIrMetaFetcher;
import com.alibaba.graphscope.common.ir.meta.reader.IrMetaReader;
import com.alibaba.graphscope.common.ir.planner.GraphRelOptimizer;
import com.alibaba.graphscope.common.manager.IrMetaQueryCallback;
import com.alibaba.graphscope.frontend.VineyardIrMetaReader;
import com.alibaba.graphscope.gremlin.integration.result.GraphProperties;
import com.alibaba.graphscope.gremlin.integration.result.TestGraphFactory;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Frontend
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Frontend.class);
    private GraphServer graphServer;
    private Configs configs;

    public Frontend(String configFile) throws IOException {
        this(new Configs(configFile));
    }

    public Frontend(Configs configs) {
        this.configs = configs;
    }

    public void start() throws Exception {
        HostsRpcChannelFetcher channelFetcher = new HostsRpcChannelFetcher(this.configs);
        GraphRelOptimizer optimizer = new GraphRelOptimizer(this.configs);
        IrMetaQueryCallback queryCallback = new IrMetaQueryCallback((IrMetaFetcher)new StaticIrMetaFetcher((IrMetaReader)new VineyardIrMetaReader(this.configs), (IrMetaTracker)optimizer.getGlogueHolder()));
        this.graphServer = new GraphServer(this.configs, (ChannelFetcher)channelFetcher, queryCallback, (GraphProperties)TestGraphFactory.VINEYARD, optimizer);
        this.graphServer.start();
    }

    @Override
    public void close() throws Exception {
        if (this.graphServer != null) {
            this.graphServer.close();
        }
    }

    public static void main(String[] args) {
        logger.info("start to run Frontend.");
        if (args == null || args.length < 1) {
            logger.error("Please give the path of config file.");
            System.exit(1);
        }
        try (Frontend frontend = new Frontend(args[0]);){
            frontend.start();
            CountDownLatch shutdown = new CountDownLatch(1);
            shutdown.await();
        }
        catch (Throwable t) {
            logger.error("Error in frontend main:", t);
            System.exit(1);
        }
        System.exit(0);
    }
}

