/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.UUID;
import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.AbstractSystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.TopologyGraphDbmsModel;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class DefaultSystemGraphComponent
extends AbstractSystemGraphComponent {
    private final NormalizedDatabaseName defaultDbName;
    private final Clock clock;

    public DefaultSystemGraphComponent(Config config, Clock clock) {
        super(config);
        this.defaultDbName = new NormalizedDatabaseName((String)config.get(GraphDatabaseSettings.default_database));
        this.clock = clock;
    }

    public String componentName() {
        return "multi-database";
    }

    public SystemGraphComponent.Status detect(Transaction tx) {
        return DefaultSystemGraphComponent.hasDatabaseNode(tx) ? (DefaultSystemGraphComponent.hasSystemDatabaseNode(tx) ? SystemGraphComponent.Status.CURRENT : SystemGraphComponent.Status.UNSUPPORTED) : SystemGraphComponent.Status.UNINITIALIZED;
    }

    protected void initializeSystemGraphConstraints(Transaction tx) {
        DefaultSystemGraphComponent.initializeSystemGraphConstraint((Transaction)tx, (Label)TopologyGraphDbmsModel.DATABASE_NAME_LABEL, (String)"name");
        DefaultSystemGraphComponent.initializeSystemGraphConstraint((Transaction)tx, (Label)TopologyGraphDbmsModel.DATABASE_LABEL, (String)"name");
    }

    public void initializeSystemGraphModel(GraphDatabaseService system) throws InvalidArgumentsException {
        this.newDefaultDb(system);
        this.newDb(system, new NormalizedDatabaseName("system"), false, NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID.databaseId().uuid());
    }

    protected void maybeStopDatabase(Node oldDatabaseNode) {
        oldDatabaseNode.setProperty("status", (Object)TopologyGraphDbmsModel.DatabaseStatus.offline.name());
    }

    protected void verifySystemGraph(GraphDatabaseService system) throws Exception {
        this.updateDefaultDatabase(system);
    }

    public void upgradeToCurrent(GraphDatabaseService system) {
    }

    private static boolean hasDatabaseNode(Transaction tx) {
        try (ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL);){
            boolean bl = nodes.hasNext();
            return bl;
        }
    }

    private static boolean hasSystemDatabaseNode(Transaction tx) {
        try (ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL, "name", (Object)"system");){
            boolean bl = nodes.hasNext();
            return bl;
        }
    }

    private void updateDefaultDatabase(GraphDatabaseService system) throws InvalidArgumentsException {
        boolean defaultFound;
        try (Transaction tx = system.beginTx();){
            Node defaultDb;
            Function<ResourceIterator, Boolean> unsetOldNode = nodes -> {
                boolean correctDefaultFound = false;
                while (nodes.hasNext()) {
                    Node oldDb = (Node)nodes.next();
                    if (oldDb.getProperty("name").equals(this.defaultDbName.name())) {
                        correctDefaultFound = true;
                        continue;
                    }
                    oldDb.setProperty("default", (Object)false);
                    this.maybeStopDatabase(oldDb);
                }
                return correctDefaultFound;
            };
            try (ResourceIterator nodes2 = tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL, "default", (Object)true);){
                defaultFound = unsetOldNode.apply(nodes2);
            }
            nodes2 = tx.findNodes(TopologyGraphDbmsModel.DELETED_DATABASE_LABEL, "default", (Object)true);
            try {
                unsetOldNode.apply(nodes2);
            }
            finally {
                if (nodes2 != null) {
                    nodes2.close();
                }
            }
            if (!defaultFound && (defaultDb = tx.findNode(TopologyGraphDbmsModel.DATABASE_LABEL, "name", (Object)this.defaultDbName.name())) != null) {
                defaultDb.setProperty("default", (Object)true);
                defaultDb.setProperty("status", (Object)TopologyGraphDbmsModel.DatabaseStatus.online.name());
                defaultFound = true;
            }
            tx.commit();
        }
        if (!defaultFound) {
            this.newDb(system, this.defaultDbName, true, UUID.randomUUID());
        }
    }

    private void newDefaultDb(GraphDatabaseService system) throws InvalidArgumentsException {
        this.newDb(system, this.defaultDbName, true, UUID.randomUUID());
    }

    private void newDb(GraphDatabaseService system, NormalizedDatabaseName databaseName, boolean defaultDb, UUID uuid) throws InvalidArgumentsException {
        try (Transaction tx = system.beginTx();){
            this.createDatabaseNode(tx, databaseName.name(), defaultDb, uuid, ZonedDateTime.ofInstant(this.clock.instant(), this.clock.getZone()));
            tx.commit();
        }
        catch (ConstraintViolationException e) {
            throw new InvalidArgumentsException("The specified database '" + databaseName + "' already exists.");
        }
    }

    protected Node createDatabaseNode(Transaction tx, String databaseName, boolean defaultDb, UUID uuid, ZonedDateTime now) {
        Node databaseNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.DATABASE_LABEL});
        databaseNode.setProperty("name", (Object)databaseName);
        databaseNode.setProperty("uuid", (Object)uuid.toString());
        databaseNode.setProperty("status", (Object)TopologyGraphDbmsModel.DatabaseStatus.online.name());
        databaseNode.setProperty("default", (Object)defaultDb);
        databaseNode.setProperty("created_at", (Object)now);
        databaseNode.setProperty("started_at", (Object)now);
        Node nameNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.DATABASE_NAME_LABEL});
        nameNode.setProperty("name", (Object)databaseName);
        nameNode.setProperty("primary", (Object)true);
        nameNode.createRelationshipTo(databaseNode, TopologyGraphDbmsModel.TARGETS_RELATIONSHIP);
        return databaseNode;
    }
}

