/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.edition;

import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.database.readonly.ConfigBasedLookupFactory;
import org.neo4j.configuration.database.readonly.ConfigReadOnlyDatabaseListener;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.dbms.database.DbmsRuntimeSystemGraphComponent;
import org.neo4j.dbms.database.StandaloneDatabaseContext;
import org.neo4j.dbms.database.StandaloneDbmsRuntimeRepository;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.dbms.database.readonly.SystemGraphReadOnlyDatabaseLookupFactory;
import org.neo4j.dbms.database.readonly.SystemGraphReadOnlyListener;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.graphdb.factory.module.edition.context.EditionDatabaseComponents;
import org.neo4j.graphdb.factory.module.edition.context.StandaloneDatabaseComponents;
import org.neo4j.graphdb.factory.module.id.IdContextFactory;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.token.TokenHolders;

public abstract class StandaloneEditionModule
extends AbstractEditionModule {
    protected CommitProcessFactory commitProcessFactory;
    IdContextFactory idContextFactory;
    Function<NamedDatabaseId, TokenHolders> tokenHoldersProvider;
    Supplier<Locks> locksSupplier;

    @Override
    public EditionDatabaseComponents createDatabaseComponents(NamedDatabaseId namedDatabaseId) {
        return new StandaloneDatabaseComponents(this, namedDatabaseId);
    }

    public CommitProcessFactory getCommitProcessFactory() {
        return this.commitProcessFactory;
    }

    public IdContextFactory getIdContextFactory() {
        return this.idContextFactory;
    }

    public Function<NamedDatabaseId, TokenHolders> getTokenHoldersProvider() {
        return this.tokenHoldersProvider;
    }

    public Supplier<Locks> getLocksSupplier() {
        return this.locksSupplier;
    }

    public abstract DatabaseManager<? extends StandaloneDatabaseContext> createDatabaseManager(GlobalModule var1);

    protected static ReadOnlyDatabases createGlobalReadOnlyChecker(DatabaseManager<?> databaseManager, Config globalConfig, GlobalTransactionEventListeners txListeners, LifeSupport globalLife, LogProvider logProvider) {
        SystemGraphReadOnlyDatabaseLookupFactory systemGraphReadOnlyLookup = new SystemGraphReadOnlyDatabaseLookupFactory(databaseManager, logProvider);
        ConfigBasedLookupFactory configReadOnlyLookup = new ConfigBasedLookupFactory(globalConfig);
        ReadOnlyDatabases globalChecker = new ReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{systemGraphReadOnlyLookup, configReadOnlyLookup});
        ConfigReadOnlyDatabaseListener configListener = new ConfigReadOnlyDatabaseListener(globalChecker, globalConfig);
        SystemGraphReadOnlyListener systemGraphListener = new SystemGraphReadOnlyListener(txListeners, globalChecker);
        globalLife.add((Lifecycle)configListener);
        globalLife.add((Lifecycle)systemGraphListener);
        return globalChecker;
    }

    @Override
    public DbmsRuntimeRepository createAndRegisterDbmsRuntimeRepository(GlobalModule globalModule, DatabaseManager<?> databaseManager, Dependencies dependencies, DbmsRuntimeSystemGraphComponent dbmsRuntimeSystemGraphComponent) {
        StandaloneDbmsRuntimeRepository dbmsRuntimeRepository = new StandaloneDbmsRuntimeRepository(databaseManager, dbmsRuntimeSystemGraphComponent);
        globalModule.getTransactionEventListeners().registerTransactionEventListener("system", (TransactionEventListener)dbmsRuntimeRepository);
        return dbmsRuntimeRepository;
    }
}

