/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Arrays;
import org.neo4j.util.Preconditions;

public abstract class PropertySelection {
    private final boolean keysOnly;
    public static final PropertySelection ALL_PROPERTIES = PropertySelection.allProperties(false);
    public static final PropertySelection ALL_PROPERTY_KEYS = PropertySelection.allProperties(true);

    protected PropertySelection(boolean keysOnly) {
        this.keysOnly = keysOnly;
    }

    public abstract boolean isLimited();

    public abstract int numberOfKeys();

    public abstract int key(int var1);

    public abstract boolean test(int var1);

    public boolean isKeysOnly() {
        return this.keysOnly;
    }

    public String toString() {
        return String.format("Property%sSelection", this.keysOnly ? "Key" : "");
    }

    public static PropertySelection selection(int ... keys) {
        return PropertySelection.selection(false, keys);
    }

    public static PropertySelection onlyKeysSelection(int ... keys) {
        return PropertySelection.selection(true, keys);
    }

    private static PropertySelection selection(boolean keysOnly, int[] keys) {
        if (keys == null) {
            return keysOnly ? ALL_PROPERTY_KEYS : ALL_PROPERTIES;
        }
        Preconditions.checkState((keys.length > 0 ? 1 : 0) != 0, (String)"Can't make a property selection of zero keys");
        return keys.length == 1 ? new SingleKey(keysOnly, keys[0]) : new MultipleKeys(keysOnly, keys);
    }

    private static PropertySelection allProperties(boolean keysOnly) {
        return new PropertySelection(keysOnly){

            @Override
            public boolean isLimited() {
                return false;
            }

            @Override
            public int numberOfKeys() {
                return 1;
            }

            @Override
            public int key(int index) {
                return -1;
            }

            @Override
            public boolean test(int key) {
                return true;
            }

            @Override
            public String toString() {
                return super.toString() + "[*]";
            }
        };
    }

    private static class MultipleKeys
    extends PropertySelection {
        private final int[] keys;

        private MultipleKeys(boolean keysOnly, int[] keys) {
            super(keysOnly);
            this.keys = keys;
        }

        @Override
        public boolean isLimited() {
            return true;
        }

        @Override
        public int numberOfKeys() {
            return this.keys.length;
        }

        @Override
        public int key(int index) {
            assert (index >= 0 && index < this.keys.length);
            return this.keys[index];
        }

        @Override
        public boolean test(int key) {
            for (int k : this.keys) {
                if (k != key) continue;
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return super.toString() + "[" + Arrays.toString(this.keys) + "]";
        }
    }

    private static class SingleKey
    extends PropertySelection {
        private final int key;

        private SingleKey(boolean keysOnly, int key) {
            super(keysOnly);
            this.key = key;
        }

        @Override
        public boolean isLimited() {
            return true;
        }

        @Override
        public int numberOfKeys() {
            return 1;
        }

        @Override
        public int key(int index) {
            assert (index == 0);
            return this.key;
        }

        @Override
        public boolean test(int key) {
            return this.key == key;
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this.key + "]";
        }
    }
}

