/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.migration;

import java.io.IOException;
import org.neo4j.common.ProgressReporter;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.format.CapabilityType;
import org.neo4j.storageengine.migration.AbstractStoreMigrationParticipant;

public class TokenIndexMigrator
extends AbstractStoreMigrationParticipant {
    private final FileSystemAbstraction fileSystem;
    private final StorageEngineFactory storageEngineFactory;
    private final DatabaseLayout layout;
    private boolean deleteRelationshipTokenIndex;

    public TokenIndexMigrator(String name, FileSystemAbstraction fileSystem, StorageEngineFactory storageEngineFactory, DatabaseLayout layout) {
        super(name);
        this.fileSystem = fileSystem;
        this.storageEngineFactory = storageEngineFactory;
        this.layout = layout;
    }

    @Override
    public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressReporter progressReporter, String versionToMigrateFrom, String versionToMigrateTo, IndexImporterFactory indexImporterFactory) {
        StoreVersion toVersion;
        StoreVersion fromVersion = this.storageEngineFactory.versionInformation(versionToMigrateFrom);
        this.deleteRelationshipTokenIndex = !fromVersion.hasCompatibleCapabilities(toVersion = this.storageEngineFactory.versionInformation(versionToMigrateTo), CapabilityType.FORMAT);
    }

    @Override
    public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToUpgradeFrom, String versionToMigrateTo) throws IOException {
        if (this.deleteRelationshipTokenIndex) {
            this.fileSystem.deleteFile(this.layout.relationshipTypeScanStore());
        }
    }

    @Override
    public void cleanup(DatabaseLayout migrationLayout) {
    }
}

