/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.function.Predicate;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.impl.OrderedByTypeExpander;
import org.neo4j.graphdb.impl.StandardExpander;

public class PathExpanderBuilder {
    private final StandardExpander expander;

    public static PathExpanderBuilder empty() {
        return new PathExpanderBuilder(StandardExpander.EMPTY);
    }

    public static PathExpanderBuilder emptyOrderedByType() {
        return new PathExpanderBuilder(new OrderedByTypeExpander());
    }

    public static PathExpanderBuilder allTypesAndDirections() {
        return new PathExpanderBuilder(StandardExpander.DEFAULT);
    }

    public static PathExpanderBuilder allTypes(Direction direction) {
        return new PathExpanderBuilder(StandardExpander.create(direction));
    }

    public PathExpanderBuilder add(RelationshipType type) {
        return this.add(type, Direction.BOTH);
    }

    public PathExpanderBuilder add(RelationshipType type, Direction direction) {
        return new PathExpanderBuilder(this.expander.add(type, direction));
    }

    public PathExpanderBuilder remove(RelationshipType type) {
        return new PathExpanderBuilder(this.expander.remove(type));
    }

    public PathExpanderBuilder addNodeFilter(Predicate<? super Node> filter) {
        return new PathExpanderBuilder(this.expander.addNodeFilter(filter));
    }

    public PathExpanderBuilder addRelationshipFilter(Predicate<? super Relationship> filter) {
        return new PathExpanderBuilder(this.expander.addRelationshipFilter(filter));
    }

    public <STATE> PathExpander<STATE> build() {
        return this.expander;
    }

    private PathExpanderBuilder(StandardExpander expander) {
        this.expander = expander;
    }
}

