/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdSlotDistribution;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.indexed.IndexedIdGenerator;
import org.neo4j.internal.id.indexed.LoggingIndexedIdGeneratorMonitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;

public class DefaultIdGeneratorFactory
implements IdGeneratorFactory {
    private final Map<IdType, IndexedIdGenerator> generators = new HashMap<IdType, IndexedIdGenerator>();
    protected final FileSystemAbstraction fs;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    protected final boolean allowLargeIdCaches;
    private final String databaseName;

    public DefaultIdGeneratorFactory(FileSystemAbstraction fs, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, String databaseName) {
        this(fs, recoveryCleanupWorkCollector, false, databaseName);
    }

    public DefaultIdGeneratorFactory(FileSystemAbstraction fs, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean allowLargeIdCaches, String databaseName) {
        this.fs = fs;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.allowLargeIdCaches = allowLargeIdCaches;
        this.databaseName = databaseName;
    }

    @Override
    public IdGenerator open(PageCache pageCache, Path filename, IdType idType, LongSupplier highIdScanner, long maxId, DatabaseReadOnlyChecker readOnlyChecker, Config config, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions, IdSlotDistribution slotDistribution) throws IOException {
        IndexedIdGenerator generator = this.instantiate(this.fs, pageCache, this.recoveryCleanupWorkCollector, filename, highIdScanner, maxId, idType, readOnlyChecker, config, cursorContext, this.databaseName, openOptions, slotDistribution);
        this.generators.put(idType, generator);
        return generator;
    }

    protected IndexedIdGenerator instantiate(FileSystemAbstraction fs, PageCache pageCache, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Path fileName, LongSupplier highIdSupplier, long maxValue, IdType idType, DatabaseReadOnlyChecker readOnlyChecker, Config config, CursorContext cursorContext, String databaseName, ImmutableSet<OpenOption> openOptions, IdSlotDistribution slotDistribution) {
        return new IndexedIdGenerator(pageCache, fileName, recoveryCleanupWorkCollector, idType, this.allowLargeIdCaches, highIdSupplier, maxValue, readOnlyChecker, config, databaseName, cursorContext, LoggingIndexedIdGeneratorMonitor.defaultIdMonitor(fs, fileName, config), openOptions, slotDistribution);
    }

    @Override
    public IdGenerator get(IdType idType) {
        return this.generators.get(idType);
    }

    @Override
    public IdGenerator create(PageCache pageCache, Path fileName, IdType idType, long highId, boolean throwIfFileExists, long maxId, DatabaseReadOnlyChecker readOnlyChecker, Config config, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions, IdSlotDistribution slotDistribution) throws IOException {
        if (this.fs.fileExists(fileName)) {
            this.fs.deleteFile(fileName);
        }
        IndexedIdGenerator generator = new IndexedIdGenerator(pageCache, fileName, this.recoveryCleanupWorkCollector, idType, this.allowLargeIdCaches, () -> highId, maxId, readOnlyChecker, config, this.databaseName, cursorContext, LoggingIndexedIdGeneratorMonitor.defaultIdMonitor(this.fs, fileName, config), openOptions, slotDistribution);
        generator.checkpoint(cursorContext);
        this.generators.put(idType, generator);
        return generator;
    }

    @Override
    public void visit(Consumer<IdGenerator> visitor) {
        this.generators.values().forEach(visitor);
    }

    @Override
    public void clearCache(CursorContext cursorContext) {
        this.generators.values().forEach(generator -> generator.clearCache(cursorContext));
    }

    @Override
    public Collection<Path> listIdFiles() {
        return this.generators.values().stream().map(IndexedIdGenerator::path).collect(Collectors.toList());
    }
}

