/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.pegasus;

import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcTelemetry;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcChannel {
    private static final Logger logger = LoggerFactory.getLogger(RpcChannel.class);
    private final ManagedChannel channel;

    public RpcChannel(ManagedChannel channel) {
        this.channel = channel;
    }

    public RpcChannel(String host, int port) {
        this.channel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
    }

    public RpcChannel(String host, int port, OpenTelemetry openTelemetry) {
        GrpcTelemetry grpcTelemetry = GrpcTelemetry.create((OpenTelemetry)openTelemetry);
        this.channel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().intercept(new ClientInterceptor[]{grpcTelemetry.newClientInterceptor()}).build();
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "RpcChannel: " + this.channel.authority();
    }
}

