/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.pegasus;

import com.alibaba.pegasus.RpcChannel;
import com.alibaba.pegasus.intf.ResultProcessor;
import com.alibaba.pegasus.service.protocol.JobServiceGrpc;
import com.alibaba.pegasus.service.protocol.PegasusClient;
import io.grpc.Channel;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import io.opentelemetry.api.trace.Span;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClient {
    private static final Logger logger = LoggerFactory.getLogger(RpcClient.class);
    private final List<RpcChannel> channels;
    private final List<JobServiceGrpc.JobServiceStub> serviceStubs;

    public RpcClient(List<RpcChannel> channels) {
        this.channels = Objects.requireNonNull(channels);
        this.serviceStubs = channels.stream().map(k -> JobServiceGrpc.newStub((Channel)k.getChannel())).collect(Collectors.toList());
    }

    public void submit(PegasusClient.JobRequest jobRequest, ResultProcessor processor, long rpcTimeoutMS) {
        AtomicInteger counter = new AtomicInteger(this.channels.size());
        AtomicBoolean finished = new AtomicBoolean(false);
        this.serviceStubs.forEach(asyncStub -> ((JobServiceGrpc.JobServiceStub)asyncStub.withDeadlineAfter(rpcTimeoutMS, TimeUnit.MILLISECONDS)).submit(jobRequest, new JobResponseObserver(processor, finished, counter)));
    }

    public void shutdown() throws InterruptedException {
        for (RpcChannel rpcChannel : this.channels) {
            rpcChannel.shutdown();
        }
    }

    private static class JobResponseObserver
    implements StreamObserver<PegasusClient.JobResponse> {
        private final ResultProcessor processor;
        private final AtomicBoolean finished;
        private final AtomicInteger counter;

        public JobResponseObserver(ResultProcessor processor, AtomicBoolean finished, AtomicInteger counter) {
            this.processor = processor;
            this.finished = finished;
            this.counter = counter;
        }

        public void onNext(PegasusClient.JobResponse jobResponse) {
            if (this.finished.get()) {
                return;
            }
            try {
                this.processor.process(jobResponse);
            }
            catch (Throwable t) {
                this.onError(t);
            }
        }

        public void onError(Throwable throwable) {
            if (this.finished.getAndSet(true)) {
                return;
            }
            Status status = Status.fromThrowable((Throwable)throwable);
            logger.debug("get job response error: {}", (Object)status);
            this.processor.error(status);
        }

        public void onCompleted() {
            if (this.counter.decrementAndGet() == 0) {
                String traceId = Span.current().getSpanContext().getTraceId();
                logger.info("trace: {}, finish get job response from all servers", (Object)traceId);
                try {
                    this.processor.finish();
                }
                catch (Throwable t) {
                    this.onError(t);
                }
            }
        }
    }
}

