/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Objects;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public class HeapTrackingLongHashSet
extends LongHashSet
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingLongHashSet.class);
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final MemoryTracker memoryTracker;
    private int trackedCapacity;

    static HeapTrackingLongHashSet createLongHashSet(MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapTrackingLongHashSet.arrayHeapSize(16));
        return new HeapTrackingLongHashSet(memoryTracker);
    }

    static HeapTrackingLongHashSet createLongHashSet(MemoryTracker memoryTracker, int initialCapacity) {
        int capacity = HeapTrackingLongHashSet.smallestPowerOfTwoGreaterThan(initialCapacity);
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapTrackingLongHashSet.arrayHeapSize(capacity));
        return new HeapTrackingLongHashSet(memoryTracker, capacity);
    }

    private HeapTrackingLongHashSet(MemoryTracker memoryTracker) {
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trackedCapacity = 16;
    }

    private HeapTrackingLongHashSet(MemoryTracker memoryTracker, int initialCapacity) {
        super(initialCapacity);
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trackedCapacity = initialCapacity;
    }

    private static int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    protected void allocateTable(int sizeToAllocate) {
        if (this.memoryTracker != null) {
            this.memoryTracker.allocateHeap(HeapTrackingLongHashSet.arrayHeapSize(sizeToAllocate));
            this.memoryTracker.releaseHeap(HeapTrackingLongHashSet.arrayHeapSize(this.trackedCapacity));
            this.trackedCapacity = sizeToAllocate;
        }
        super.allocateTable(sizeToAllocate);
    }

    @Override
    public void close() {
        this.memoryTracker.releaseHeap(HeapTrackingLongHashSet.arrayHeapSize(this.trackedCapacity) + SHALLOW_SIZE);
    }

    static long arrayHeapSize(int arrayLength) {
        return HeapEstimator.alignObjectSize((long)((long)HeapEstimator.ARRAY_HEADER_BYTES + (long)arrayLength * 8L));
    }
}

