/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.interactive.client;

import com.alibaba.graphscope.interactive.client.Session;
import com.alibaba.graphscope.interactive.client.common.Result;
import com.alibaba.graphscope.interactive.client.impl.DefaultSession;
import com.alibaba.graphscope.interactive.models.ServiceStatus;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.SessionConfig;

public class Driver {
    private static final Logger logger = Logger.getLogger(Driver.class.getName());
    private final String adminUri;
    private final String storedProcUri;
    private String cypherUri;
    private String gremlinUri;
    private String host;
    private int port;
    private Session defaultSession;

    public static Driver connect() {
        String gremlinUri;
        String cypherUri;
        String adminUri = System.getenv("INTERACTIVE_ADMIN_ENDPOINT");
        if (adminUri == null) {
            throw new IllegalArgumentException("INTERACTIVE_ADMIN_ENDPOINT is not set");
        }
        String storedProcUri = System.getenv("INTERACTIVE_STORED_PROC_ENDPOINT");
        if (storedProcUri == null) {
            logger.warning("INTERACTIVE_STORED_PROC_ENDPOINT is not set, will try to parse endpoint from service_status");
        }
        if ((cypherUri = System.getenv("INTERACTIVE_CYPHER_ENDPOINT")) == null) {
            logger.warning("INTERACTIVE_CYPHER_ENDPOINT is not set, will try to parse endpoint from service_status");
        }
        if ((gremlinUri = System.getenv("INTERACTIVE_GREMLIN_ENDPOINT")) == null) {
            logger.warning("INTERACTIVE_GREMLIN_ENDPOINT is not set, will try to parse endpoint from service_status");
        }
        return Driver.connect(adminUri, storedProcUri, cypherUri, gremlinUri);
    }

    public static Driver connect(String adminUri, String storedProcUri, String cypherUri, String gremlinUri) {
        return new Driver(adminUri, storedProcUri, cypherUri, gremlinUri);
    }

    public static Driver connect(String uri) {
        return new Driver(uri);
    }

    private Driver(String uri) {
        this.adminUri = uri;
        this.storedProcUri = null;
        this.cypherUri = null;
        this.gremlinUri = null;
        this.initHostPort();
        this.defaultSession = null;
    }

    private Driver(String adminUri, String storedProcUri, String cypherUri, String gremlinUri) {
        this.adminUri = adminUri;
        this.storedProcUri = storedProcUri;
        this.cypherUri = cypherUri;
        this.gremlinUri = gremlinUri;
        if (storedProcUri != null && !storedProcUri.startsWith("http")) {
            throw new IllegalArgumentException("Invalid uri: " + storedProcUri);
        }
        this.initHostPort();
        this.defaultSession = null;
    }

    public Session session() {
        if (this.storedProcUri == null) {
            return DefaultSession.newInstance(this.adminUri);
        }
        return DefaultSession.newInstance(this.adminUri, this.storedProcUri);
    }

    public Session getDefaultSession() {
        if (this.defaultSession == null) {
            this.defaultSession = this.session();
        }
        return this.defaultSession;
    }

    public org.neo4j.driver.Session getNeo4jSession(SessionConfig sessionConfig) {
        return this.getNeo4jSessionImpl(sessionConfig);
    }

    public org.neo4j.driver.Session getNeo4jSession() {
        SessionConfig sessionConfig = SessionConfig.builder().build();
        return this.getNeo4jSessionImpl(sessionConfig);
    }

    public String getNeo4jEndpoint() {
        if (this.cypherUri != null) {
            return this.cypherUri;
        }
        Pair<String, Integer> endpoint = this.getNeo4jEndpointImpl();
        if (endpoint == null) {
            return null;
        }
        this.cypherUri = "bolt://" + (String)endpoint.getLeft() + ":" + endpoint.getRight();
        return this.cypherUri;
    }

    public Pair<String, Integer> getGremlinEndpoint() {
        return this.getGremlinEndpointImpl();
    }

    public Client getGremlinClient() {
        Pair<String, Integer> endpoint = this.getGremlinEndpoint();
        Cluster cluster = Cluster.build().addContactPoint((String)endpoint.getLeft()).port(((Integer)endpoint.getRight()).intValue()).create();
        return cluster.connect();
    }

    private org.neo4j.driver.Session getNeo4jSessionImpl(SessionConfig sessionConfig) {
        Pair<String, Integer> endpoint = this.getNeo4jEndpointImpl();
        String boltUri = "neo4j://" + (String)endpoint.getLeft() + ":" + endpoint.getRight();
        logger.info("Connecting to neo4j with uri: " + boltUri);
        org.neo4j.driver.Driver driver = GraphDatabase.driver((String)boltUri);
        return driver.session(sessionConfig);
    }

    private Pair<String, Integer> getNeo4jEndpointImpl() {
        Session gsSession = this.getDefaultSession();
        Result<ServiceStatus> serviceStatus = gsSession.getServiceStatus();
        if (!serviceStatus.isOk()) {
            throw new RuntimeException("Failed to get service status: " + serviceStatus.getStatusMessage());
        }
        ServiceStatus status = serviceStatus.getValue();
        Integer boltPort = status.getBoltPort();
        if (!status.getStatus().equals("Running")) {
            throw new RuntimeException("Interactive Query Service is not running");
        }
        return Pair.of((Object)this.host, (Object)boltPort);
    }

    private Pair<String, Integer> getGremlinEndpointImpl() {
        if (this.gremlinUri != null) {
            String[] parts = this.gremlinUri.split(":");
            if (parts.length != 3) {
                throw new IllegalArgumentException("Invalid uri: " + this.gremlinUri);
            }
            String host = parts[1].substring(2);
            String portStr = parts[2].split("/")[0];
            Integer port = Integer.parseInt(portStr);
            return Pair.of((Object)host, (Object)port);
        }
        Session gsSession = this.getDefaultSession();
        Result<ServiceStatus> serviceStatus = gsSession.getServiceStatus();
        if (!serviceStatus.isOk()) {
            throw new RuntimeException("Failed to get service status: " + serviceStatus.getStatusMessage());
        }
        ServiceStatus status = serviceStatus.getValue();
        Integer gremlinPort = status.getGremlinPort();
        return Pair.of((Object)this.host, (Object)gremlinPort);
    }

    private void initHostPort() {
        if (!this.adminUri.startsWith("http")) {
            throw new IllegalArgumentException("Invalid uri: " + this.adminUri);
        }
        String[] parts = this.adminUri.split(":");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid uri: " + this.adminUri);
        }
        this.host = parts[1].substring(2);
        this.port = Integer.parseInt(parts[2]);
    }
}

