/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.interactive.client.common;

import com.alibaba.graphscope.interactive.ApiException;
import com.alibaba.graphscope.interactive.ApiResponse;

public class Status {
    private final StatusCode code;
    private final String message;

    public Status() {
        this.code = StatusCode.kUnknown;
        this.message = "";
    }

    public boolean IsOk() {
        return this.code == StatusCode.kOk;
    }

    public String getMessage() {
        return this.message;
    }

    public StatusCode getCode() {
        return this.code;
    }

    public Status(StatusCode code, String message) {
        this.code = code;
        this.message = message;
    }

    public static Status ok(String message) {
        return new Status(StatusCode.kOk, message);
    }

    public static Status badRequest(String message) {
        return new Status(StatusCode.kBadRequest, message);
    }

    public static Status serverInternalError(String message) {
        return new Status(StatusCode.kServerInternalError, message);
    }

    public static Status fromException(ApiException exception) {
        switch (exception.getCode()) {
            case 400: {
                return new Status(StatusCode.kBadRequest, exception.getMessage());
            }
            case 403: {
                return new Status(StatusCode.kForbidden, exception.getMessage());
            }
            case 404: {
                return new Status(StatusCode.kNotFound, exception.getMessage());
            }
            case 500: {
                return new Status(StatusCode.kServerInternalError, exception.getMessage());
            }
            case 503: {
                return new Status(StatusCode.kServiceUnavailable, exception.getMessage());
            }
        }
        return new Status(StatusCode.kUnknown, exception.getMessage());
    }

    public static <T> Status fromResponse(ApiResponse<T> response) {
        switch (response.getStatusCode()) {
            case 200: {
                return new Status(StatusCode.kOk, "");
            }
            case 400: {
                return new Status(StatusCode.kBadRequest, "");
            }
            case 403: {
                return new Status(StatusCode.kForbidden, "");
            }
            case 404: {
                return new Status(StatusCode.kNotFound, "");
            }
            case 500: {
                return new Status(StatusCode.kServerInternalError, "");
            }
            case 503: {
                return new Status(StatusCode.kServiceUnavailable, "");
            }
        }
        return new Status(StatusCode.kUnknown, "");
    }

    public static Status Ok() {
        return new Status(StatusCode.kOk, "");
    }

    static enum StatusCode {
        kOk,
        kBadRequest,
        kForbidden,
        kNotFound,
        kServerInternalError,
        kServiceUnavailable,
        kUnknown;

    }
}

